/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber;

import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABEREngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABERKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABERParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;

public class SABERKEMExtractor
implements EncapsulatedSecretExtractor {
    private SABEREngine engine;
    private SABERKeyParameters key;

    public SABERKEMExtractor(SABERKeyParameters privParams) {
        this.key = privParams;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(SABERParameters param) {
        this.engine = param.getEngine();
    }

    @Override
    public byte[] extractSecret(byte[] encapsulation) {
        byte[] session_key = new byte[this.engine.getSessionKeySize()];
        this.engine.crypto_kem_dec(session_key, encapsulation, ((SABERPrivateKeyParameters)this.key).getPrivateKey());
        return session_key;
    }

    @Override
    public int getEncapsulationLength() {
        return this.engine.getCipherTextSize();
    }
}

