/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.smime;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ACryptographyKey;
import net.savignano.cryptography.key.ISecretCryptographyKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeDecryptionKey
extends ACryptographyKey<PrivateKey>
implements ISecretCryptographyKey<PrivateKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeDecryptionKey.class);
    private PrivateKey key;
    private X509Certificate cert;

    public SmimeDecryptionKey(PrivateKey key) {
        super(EKeyPurpose.DECRYPTION, ECryptographyType.SMIME);
        this.key = key;
        if (key == null) {
            log.warn("Key was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
        }
    }

    public SmimeDecryptionKey(PrivateKey key, X509Certificate cert) {
        this(key);
        this.cert = cert;
    }

    public SmimeDecryptionKey(EKeyValidity validity) {
        this(validity, EKeySource.UNKNOWN);
    }

    public SmimeDecryptionKey(EKeyValidity validity, EKeySource keySource) {
        super(EKeyPurpose.DECRYPTION, ECryptographyType.SMIME);
        this.setKeyValidity(validity);
        this.setKeySource(keySource);
    }

    @Override
    public PrivateKey getKey() {
        return this.key;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    @Override
    public void destroy() {
        this.setKeyValidity(EKeyValidity.INVALID);
        this.key = null;
        this.cert = null;
    }

    @Override
    public boolean isDestroyed() {
        return this.key == null && this.getKeyValidity() == EKeyValidity.INVALID;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("S/MIME Decryption Key. ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        builder.append("; Certificate: ");
        builder.append(this.getCertificate());
        return builder.toString();
    }
}

