/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.visitor;

import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimePart;
import jakarta.mail.internet.MimeUtility;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.savignano.cryptography.mail.visitor.ResultMessageVisitor;

public class RegexVisitor
extends ResultMessageVisitor<List<MatchResult>> {
    private final Pattern pattern;
    private boolean checkHeaders;

    public RegexVisitor(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern must not be null.");
        }
        this.getLog().trace("Pattern used: {}", (Object)pattern.pattern());
        this.pattern = pattern;
        this.setResult(new ArrayList());
        this.setContentType("text/*");
    }

    @Override
    public void visit(MimeMessage msg) throws Exception {
        super.visit(msg);
        if (this.isCheckHeaders()) {
            this.checkHeaders(msg);
        }
    }

    @Override
    protected void handlePart(MimePart part) throws Exception {
        this.getLog().trace("Found text content. Content transfer encoding: {}", (Object)part.getHeader("Content-Transfer-Encoding", null));
        Object content = part.getContent();
        if (content == null) {
            this.getLog().warn("Null content in messge with ID: ", (Object)this.getMsgId());
        } else {
            this.checkForMatch(content.toString());
        }
    }

    private void checkHeaders(MimeMessage msg) throws MessagingException {
        Enumeration headers = msg.getAllHeaders();
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            try {
                String value = MimeUtility.unfold((String)MimeUtility.decodeText((String)header.getValue()));
                this.checkForMatch(header.getName() + ": " + value);
            }
            catch (UnsupportedEncodingException e) {
                this.getLog().warn("Could not decode header \"" + header.getName() + "\" in message with ID \"" + this.getMsgId() + "\". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void checkForMatch(String content) {
        Matcher matcher = this.pattern.matcher(content);
        while (matcher.find()) {
            this.getLog().trace("Found match: {}", (Object)matcher.group());
            ((List)this.getResult()).add(matcher.toMatchResult());
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.setResult(new ArrayList());
    }

    public boolean isCheckHeaders() {
        return this.checkHeaders;
    }

    public void setCheckHeaders(boolean checkHeaders) {
        this.checkHeaders = checkHeaders;
    }

    @Override
    public void setContentType(String contentType) {
        super.setContentType(contentType == null ? "text/*" : contentType);
    }
}

