/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.visitor.extract;

import jakarta.mail.Message;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Optional;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.smime.SmimeCertificateKeyStoreLoader;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.mail.validate.SmimeMailValidator;
import net.savignano.cryptography.mail.visitor.extract.AMailExtractor;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESigned;
import net.savignano.thirdparty.org.bouncycastle.util.Store;

public class SmimeMailExtractor
extends AMailExtractor<SmimeEncryptionKey> {
    public SmimeMailExtractor(Session session) {
        super(session, ECryptographyType.SMIME);
    }

    @Override
    protected SmimeEncryptionKey doExtract(MimeMessage msg, String email) throws Exception {
        Optional<X509Certificate> cert = this.handlePart(msg, email);
        if (!cert.isPresent()) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        SmimeEncryptionKey key = new SmimeEncryptionKey(cert.get(), email);
        key.setKeySource(EKeySource.EMAIL);
        return key;
    }

    private Optional<X509Certificate> handlePart(MimeMessage msg, String email) throws Exception {
        ContentType type = new ContentType(msg.getContentType());
        this.getLog().trace("Checking MIME type: {}", (Object)type);
        if (SmimeMailValidator.isMessageTransparentSigned((Message)msg)) {
            this.getLog().debug("Found '{}' content.", (Object)type);
            MimeMultipart mp = (MimeMultipart)msg.getContent();
            String encoding = msg.getEncoding();
            SMIMESigned signed = encoding == null ? new SMIMESigned(mp) : new SMIMESigned(mp, encoding);
            return Optional.ofNullable(this.extract(signed, email));
        }
        if (SmimeMailValidator.isMessageOpaqueSigned((Message)msg)) {
            this.getLog().debug("Found '{}' content.", (Object)type);
            SMIMESigned signed = new SMIMESigned((Part)msg);
            return Optional.ofNullable(this.extract(signed, email));
        }
        return Optional.empty();
    }

    private X509Certificate extract(SMIMESigned signed, String email) throws Exception {
        this.getLog().debug("Extracting public key for email: {}", (Object)email);
        Store<X509CertificateHolder> certificateHolders = signed.getCertificates();
        KeyStore keyStore = SmimeUtil.convertToKeyStore(certificateHolders, "PKCS12", null);
        SmimeCertificateKeyStoreLoader loader = new SmimeCertificateKeyStoreLoader(keyStore);
        SmimeEncryptionKey key = (SmimeEncryptionKey)loader.loadKey(email);
        return key.getKey();
    }

    @Override
    protected SmimeEncryptionKey getValidityKey(EKeyValidity validity) {
        return new SmimeEncryptionKey(validity, EKeySource.EMAIL);
    }
}

