/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.pgp;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.KeyLoaderTransformer;
import net.savignano.cryptography.key.loader.pgp.PgpGlobalDirectoryLoader;
import net.savignano.cryptography.key.loader.pgp.PgpKeyBoxLoader;
import net.savignano.cryptography.key.loader.pgp.PgpKeyServerLoader;
import net.savignano.cryptography.key.loader.pgp.PgpPublicKeyStoreLoader;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpUserKeyLoader;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.atlassian.mailer.keysource.APublicKeyManager;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBox;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpPublicKeyManager
extends APublicKeyManager<PgpEncryptionKey, IUser<?>> {
    private static final Logger log = LoggerFactory.getLogger(PgpPublicKeyManager.class);

    public PgpPublicKeyManager(ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(EProperty.EMAIL_PGP_TIME_STAMP, appProps, userProps);
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<PgpEncryptionKey, IUser<?>>>>>> getKeyLoaders() {
        ArrayList loaders = new ArrayList();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.KEYSTORE, this::createKeyStoreLoader));
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.KEYSERVER, this::createKeyServerLoader));
        return loaders;
    }

    private Optional<IKeyLoader<PgpEncryptionKey, IUser<?>>> createKeyServerLoader() {
        ISnotifyAppProperties appProps = this.getAppProps();
        String keyServer = appProps.getString(EProperty.PUBLIC_KEYSERVER_PGP_LOCATION);
        if (keyServer == null) {
            log.debug("No PGP key server configured to retrieve PGP public keys from.");
            return Optional.empty();
        }
        log.debug("PGP key server configured: {}", (Object)keyServer);
        if (keyServer.startsWith("ldap")) {
            return this.createPgpGlobalDirectoryLoader(keyServer);
        }
        return this.createHkpKeyServerLoader(keyServer);
    }

    private Optional<IKeyLoader<PgpEncryptionKey, IUser<?>>> createPgpGlobalDirectoryLoader(String keyServer) {
        URI uri;
        try {
            uri = new URI(keyServer);
        }
        catch (URISyntaxException e) {
            log.error("Could not parse key server URL '" + keyServer + "'. Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        LdapConnector connector = new LdapConnector();
        connector.setHost(uri.getHost());
        connector.setPort(uri.getPort());
        connector.setSsl("ldaps".equals(uri.getScheme()));
        PgpGlobalDirectoryLoader loader = new PgpGlobalDirectoryLoader(connector);
        return Optional.of(KeyLoaderTransformer.create(loader, u -> Pair.of(null, (Object)u.getEmail())));
    }

    private Optional<IKeyLoader<PgpEncryptionKey, IUser<?>>> createHkpKeyServerLoader(String keyServer) {
        ISnotifyAppProperties appProps = this.getAppProps();
        boolean encodeSearchParam = !appProps.getBoolean(EProperty.TWEAK_DO_NOT_ENCODE_PGP_SEARCH_PARAMETER);
        Long timeout = appProps.getLong(EProperty.TWEAK_URL_CONNECTION_TIMEOUT);
        PgpKeyServerLoader loader = new PgpKeyServerLoader(keyServer);
        loader.setEncodeSearchParam(encodeSearchParam);
        if (timeout != null && timeout.intValue() >= 0) {
            loader.setTimeout(timeout.intValue());
        }
        return Optional.of(KeyLoaderTransformer.create(loader, u -> u.getEmail()));
    }

    private Optional<IKeyLoader<PgpEncryptionKey, IUser<?>>> createKeyStoreLoader() {
        String location = this.getAppProps().getString(EProperty.PUBLIC_KEYSTORE_PGP_LOCATION);
        if (location == null) {
            log.debug("No key store specified. Can't get key from key store.");
            return Optional.empty();
        }
        String type = this.getAppProps().getString(EProperty.PUBLIC_KEYSTORE_PGP_TYPE);
        if (type == null) {
            log.debug("No key store type specified. Can't get key from key store.");
            return Optional.empty();
        }
        log.debug("Key store type: {}", (Object)type);
        switch (type) {
            case "KEYRING": {
                return this.createKeyringKeyStoreLoader(location);
            }
            case "KBX": {
                return this.createKeyBoxKeyStoreLoader(location);
            }
        }
        log.error("Could not load key store from location \"{}\". Unknown key store type encountered: {}", (Object)type);
        return Optional.empty();
    }

    private Optional<IKeyLoader<PgpEncryptionKey, IUser<?>>> createKeyringKeyStoreLoader(String location) {
        Optional<IKeyLoader<PgpEncryptionKey, IUser<?>>> optional;
        log.debug("PGP key store configured: {}", (Object)location);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));
        try {
            PGPPublicKeyRingCollection keyRings = PgpUtil.loadPublicKeys(in);
            optional = Optional.of(KeyLoaderTransformer.create(new PgpPublicKeyStoreLoader(keyRings), u -> u.getEmail()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Could not load PGP key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
                return Optional.empty();
            }
        }
        in.close();
        return optional;
    }

    private Optional<IKeyLoader<PgpEncryptionKey, IUser<?>>> createKeyBoxKeyStoreLoader(String location) {
        Optional<IKeyLoader<PgpEncryptionKey, IUser<?>>> optional;
        log.debug("KeyBox key store configured: {}", (Object)location);
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));
        try {
            KeyBox kbx = PgpUtil.loadKeyBox(in);
            optional = Optional.of(KeyLoaderTransformer.create(new PgpKeyBoxLoader(kbx), u -> u.getEmail()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Could not load PGP key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
                return Optional.empty();
            }
        }
        in.close();
        return optional;
    }

    @Override
    protected boolean isCachedKeyUsable(PgpEncryptionKey key, IUser<?> user) {
        if (!super.isCachedKeyUsable(key, user)) {
            return false;
        }
        if (key.getKeySource() == EKeySource.USER && !this.getAppProps().getBoolean(EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE)) {
            log.debug("Cached key unusable: User key, but admin does not allow such keys.");
            return false;
        }
        return true;
    }

    @Override
    protected void setCachedKey(IUser<?> user, PgpEncryptionKey key) throws IOException {
        ISnotifyUserProperties userProps = this.getUserProps();
        if (key == null) {
            log.debug("Clearing PGP key from user properties.");
            userProps.setBytes(EProperty.EMAIL_PGP_KEY, null, user);
            userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, null, user);
            userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, null, user);
        } else {
            log.debug("Storing new PGP key to user properties: {}", (Object)key.getMasterKey());
            PGPPublicKey encryptionKey = key.getKey();
            userProps.setBytes(EProperty.EMAIL_PGP_KEY, key.getEncoded(), user);
            userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, encryptionKey == null ? null : Long.valueOf(encryptionKey.getKeyID()), user);
            userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, key.getKeySource(), user);
        }
        userProps.setLong(EProperty.EMAIL_PGP_TIME_STAMP, System.currentTimeMillis(), user);
    }

    @Override
    protected PgpEncryptionKey getCachedKey(IUser<?> user) {
        if (!user.isActualUser()) {
            log.debug("No user given to retrieve PGP public keys from.");
            return this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN);
        }
        PgpUserKeyLoader loader = new PgpUserKeyLoader(this.getUserProps());
        return (PgpEncryptionKey)loader.loadKey(user);
    }

    @Override
    protected PgpEncryptionKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new PgpEncryptionKey(validity, keySource);
    }
}

