/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.common;

import com.atlassian.crowd.model.user.User;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.module.propertyset.DuplicatePropertyKeyException;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ASnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.AtlassianUser;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.jira.common.JiraUser;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
public class SnotifyUserProperties
extends ASnotifyUserProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifyUserProperties.class);
    @Autowired
    @ComponentImport
    private UserPropertyManager manager;

    @Override
    protected String get(String key, IUser<?> user) throws Exception {
        return this.getProps(user).getString(key);
    }

    @Override
    protected void set(String key, String value, IUser<?> user) throws Exception {
        this.getProps(user).setString(key, value);
    }

    @Override
    protected void remove(String key, IUser<?> user) throws Exception {
        this.getProps(user).remove(key);
    }

    @Override
    public boolean hasKey(EProperty prop, IUser<?> user) {
        if (prop == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return false;
        }
        return this.getString(prop.getKey(), user) != null || this.getUnlimitedString(prop.getKey(), user) != null;
    }

    @Override
    protected String getUnlimitedString(String key, IUser<?> user) {
        String value;
        try {
            value = this.getProps(user).getText(key);
        }
        catch (PropertyException e) {
            log.error("Property exception loading property " + key + " for " + String.valueOf(user) + ".", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            log.trace("User property \"{}\" for {} is considered null.", (Object)key, user);
            return null;
        }
        log.trace("User property \"{}\" for {} is: {}", new Object[]{key, user, value});
        return value;
    }

    @Override
    protected void setString(String key, String value, IUser<?> user) {
        try {
            PropertySet props = this.getProps(user);
            if (value == null) {
                log.trace("Removing user property \"{}\" for {}.", (Object)key, user);
                if (props.exists(key)) {
                    props.remove(key);
                }
            } else {
                try {
                    log.trace("Setting user property \"{}\" for {}: {}", new Object[]{key, user, value});
                    props.setString(key, value);
                }
                catch (DuplicatePropertyKeyException e) {
                    log.debug("Exception setting user property " + key + " for " + String.valueOf(user) + ".", (Throwable)e);
                    props.remove(key);
                    props.setString(key, value);
                }
            }
            if (log.isTraceEnabled()) {
                String newValue = props.getString(key);
                if (value == null ? newValue != null : !value.equals(newValue)) {
                    log.error("Setting of user property \"{}\" for {} failed. Expected value: \"{}\". Actual value: \"{}\"", new Object[]{key, user, value, newValue});
                }
            }
        }
        catch (PropertyException e) {
            log.error("Property exception setting user property " + key + " for " + String.valueOf(user) + ".", (Throwable)e);
        }
    }

    @Override
    protected void setUnlimitedString(String key, String value, IUser<?> user) {
        try {
            PropertySet props = this.getProps(user);
            if (value == null) {
                log.trace("Removing user property \"{}\" for {}.", (Object)key, user);
                if (props.exists(key)) {
                    props.remove(key);
                }
            } else {
                try {
                    log.trace("Setting user property \"{}\" for {}: {}", new Object[]{key, user, value});
                    props.setText(key, value);
                }
                catch (DuplicatePropertyKeyException e) {
                    log.debug("Exception setting user property " + key + " for " + String.valueOf(user) + ".", (Throwable)e);
                    props.remove(key);
                    props.setText(key, value);
                }
            }
            if (log.isTraceEnabled()) {
                String newValue = props.getText(key);
                if (value == null ? newValue != null : !value.equals(newValue)) {
                    log.error("Setting of user property \"{}\" for {} failed. Expected value: \"{}\". Actual value: \"{}\"", new Object[]{key, user, value, newValue});
                }
            }
        }
        catch (PropertyException e) {
            log.error("Property exception setting property " + key + " for user " + String.valueOf(user) + ".", (Throwable)e);
        }
    }

    private PropertySet getProps(IUser<?> user) {
        if (user instanceof JiraUser) {
            return this.getManager().getPropertySet(this.getUser((JiraUser)user));
        }
        if (user instanceof AtlassianUser) {
            return this.getManager().getPropertySet(this.getUser((AtlassianUser)user));
        }
        throw new PropertyException("Cannot handle user (" + (user == null ? null : user.getClass().getSimpleName()) + "): " + String.valueOf(user));
    }

    private ApplicationUser getUser(JiraUser user) {
        return user.getActualUser();
    }

    private ApplicationUser getUser(AtlassianUser user) {
        User actualUser = user.getActualUser();
        ApplicationUser appUser = ComponentAccessor.getUserManager().findUserInDirectory(actualUser.getName(), Long.valueOf(actualUser.getDirectoryId()));
        if (appUser != null) {
            return appUser;
        }
        throw new PropertyException("Could not find corresponding ApplicationUser for: " + String.valueOf(actualUser));
    }

    private UserPropertyManager getManager() {
        if (this.manager == null) {
            log.trace("Injection of UserPropertyManager failed. Loading manually.");
            this.manager = ComponentAccessor.getUserPropertyManager();
        }
        return this.manager;
    }
}

