/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import java.net.URL;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailKeyExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraMailProjectExtractor
extends AAtlassianMailKeyExtractor {
    private static final Logger log = LoggerFactory.getLogger(JiraMailProjectExtractor.class);
    private ProjectManager projectManager;
    private IssueManager issueManager;

    public JiraMailProjectExtractor(String baseUrl) {
        super(baseUrl);
    }

    @Override
    protected String getKey(URL url) {
        String path = url.getPath();
        if (path.contains("/browse/")) {
            return this.transformToProjectKey(path.substring(path.lastIndexOf(47) + 1));
        }
        if (path.contains("/servicedesk/customer/portal/")) {
            return this.transformToProjectKey(path.substring(path.lastIndexOf(47) + 1));
        }
        return null;
    }

    private String transformToProjectKey(String match) {
        Project project = this.getProjectManager().getProjectByCurrentKey(match);
        if (project != null) {
            log.debug("Match {} is a project.", (Object)match);
            return match;
        }
        MutableIssue issue = this.getIssueManager().getIssueByCurrentKey(match);
        if (issue != null) {
            String projectKey = issue.getProjectObject().getKey();
            log.debug("Match {} is an issue belonging to project {}.", (Object)match, (Object)projectKey);
            return projectKey;
        }
        log.debug("Match {} is neither an issue nor a project.", (Object)match);
        return null;
    }

    private ProjectManager getProjectManager() {
        if (this.projectManager == null) {
            this.projectManager = ComponentAccessor.getProjectManager();
        }
        return this.projectManager;
    }

    private IssueManager getIssueManager() {
        if (this.issueManager == null) {
            this.issueManager = ComponentAccessor.getIssueManager();
        }
        return this.issueManager;
    }
}

