/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.decorator;

import net.savignano.snotify.jira.mailer.decorator.ImageDecoration;

public enum EIconDecorator {
    MESSAGE("/images/security/mail/message.svg", "VIA EMAIL", "email"),
    MESSAGE_SECURE("/images/security/mail/message-secure.svg", null, null),
    ENCRYPTED("/images/security/mail/message-encrypted.svg", "ENC OK", "encrypted"),
    ENCRYPTED_FAILURE("/images/security/mail/message-encrypted-failure.svg", "ENC FAIL", "encrypted/failure"),
    ENCRYPTED_VERIFIED("/images/security/mail/message-encrypted-verified.svg", null, null),
    ENCRYPTED_WARNING("/images/security/mail/message-encrypted-downgrade.svg", "ENC WARN", "encrypted/warning"),
    ENCRYPTED_UNKNOWN("/images/security/mail/message-encrypted-unknown.svg", "ENC ??", "encrypted/unknown"),
    UNENCRYPTED("/images/security/mail/message-not-encrypted.svg", "NO ENC", "unencrypted"),
    SIGNED("/images/security/mail/message-signed.svg", "SIG OK", "signed"),
    SIGNED_VERIFIED("/images/security/mail/message-signed-verified.svg", "SIG VER", "signed/verified"),
    SIGNED_UNVERIFIED("/images/security/mail/message-signed-unverified.svg", "SIG UNV", "signed/unverified"),
    SIGNED_UNKNOWN("/images/security/mail/message-signed-unknown.svg", "SIG ??", "signed/unknown"),
    SIGNED_MISMATCH("/images/security/mail/message-signed-mismatch.svg", "SIG ERR", "signed/error"),
    UNSIGNED("/images/security/mail/message-not-signed.svg", "NO SIG", "unsigned");

    private final String path;
    private final String title;
    private final String altName;

    private EIconDecorator(String path, String title, String altName) {
        this.path = path;
        this.title = title;
        this.altName = altName;
    }

    public ImageDecoration getDecoration(String baseUrl, String guiKey) {
        StringBuilder builder = new StringBuilder(100);
        builder.append(baseUrl);
        if (baseUrl.charAt(baseUrl.length() - 1) != '/') {
            builder.append('/');
        }
        builder.append("download/resources/");
        builder.append(guiKey);
        builder.append(":snotify-resources");
        builder.append(this.path);
        return new ImageDecoration(builder.toString(), this.title, this.altName);
    }
}

