/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.decrypt;

import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import net.savignano.cryptography.key.ISecretCryptographyKey;
import net.savignano.cryptography.key.pgp.PgpDecryptionKey;
import net.savignano.cryptography.key.smime.SmimeDecryptionKey;
import net.savignano.cryptography.mail.IKeyProvider;
import net.savignano.cryptography.mail.ISessionProvider;
import net.savignano.cryptography.mail.decrypt.IMailDecryptor;
import net.savignano.cryptography.mail.decrypt.PgpMailDecryptor;
import net.savignano.cryptography.mail.decrypt.SmimeMailDecryptor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.version.ProductInformation;
import net.savignano.snotify.jira.mailer.decrypt.IComposedMailDecryptor;
import net.savignano.thirdparty.org.bouncycastle.cms.KeyTransRecipientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AComposedMailDecryptor
implements ISessionProvider,
IComposedMailDecryptor {
    private static final Logger log = LoggerFactory.getLogger(AComposedMailDecryptor.class);
    private final Session session;
    private final ProductInformation info;
    private boolean checkPgpInline;
    private String checkPgpBinaryAttachment;
    private SmimeMailDecryptor smimeDecryptor;
    private PgpMailDecryptor pgpDecryptor;
    private IKeyProvider<KeyTransRecipientId, SmimeDecryptionKey> smimeKeyProvider;
    private IKeyProvider<Long, PgpDecryptionKey> pgpKeyProvider;
    private boolean warning;

    public AComposedMailDecryptor(Session session, ProductInformation info) {
        this.session = session;
        this.info = info;
        if (Thread.currentThread().getContextClassLoader() == null) {
            ClassLoader msgClassLoader = Message.class.getClassLoader();
            log.warn("Context class loader of current thread is null. Setting context class loader to class loader of jakarta.mail.Message: {}", (Object)msgClassLoader);
            Thread.currentThread().setContextClassLoader(msgClassLoader);
        }
    }

    @Override
    public boolean isEncrypted(MimeMessage message) {
        return SmimeMailDecryptor.isMessageEncrypted((Message)message) || PgpMailDecryptor.isMessageEncrypted((Message)message) || this.isCheckPgpInline() && (PgpMailDecryptor.isMessageEncryptedInline((Message)message) || this.getCheckPgpBinaryAttachment() != null && PgpMailDecryptor.isMessageEncryptedBinary((Message)message, this.getCheckPgpBinaryAttachment()));
    }

    @Override
    public void decrypt(MimeMessage msg) throws IOException, MessagingException {
        this.setWarning(false);
        String msgId = MessageUtil.getMessageId((Message)msg);
        if (SmimeMailDecryptor.isMessageEncrypted((Message)msg)) {
            log.debug("Message {} is S/MIME encrypted.", (Object)msgId);
            this.decryptSmime(msg);
        } else if (PgpMailDecryptor.isMessageEncrypted((Message)msg)) {
            log.debug("Message {} is PGP encrypted.", (Object)msgId);
            this.decryptPgp(msg);
        } else if (this.isCheckPgpInline() && (PgpMailDecryptor.isMessageEncryptedInline((Message)msg) || this.getCheckPgpBinaryAttachment() != null && PgpMailDecryptor.isMessageEncryptedBinary((Message)msg, this.getCheckPgpBinaryAttachment()))) {
            log.debug("Message {} is PGP inline encrypted.", (Object)msgId);
            this.decryptPgp(msg);
        } else {
            log.debug("Message {} is not encrypted.", (Object)msgId);
        }
    }

    private void decryptSmime(MimeMessage msg) throws IOException, MessagingException {
        this.decrypt(msg, this.getSmimeKeyProvider(), this.getSmimeDecryptor());
    }

    private void decryptPgp(MimeMessage msg) throws IOException, MessagingException {
        this.decrypt(msg, this.getPgpKeyProvider(), this.getPgpDecryptor());
        this.setWarning(!this.getPgpDecryptor().isPreferredAlgorithmUsed());
    }

    private <T extends ISecretCryptographyKey<?>, U> void decrypt(MimeMessage msg, IKeyProvider<U, T> keyProvider, IMailDecryptor<T, U> decryptor) throws IOException, MessagingException {
        String msgId = MessageUtil.getMessageId((Message)msg);
        log.info("Decrypting message {}.", (Object)msgId);
        decryptor.decryptMessage(msg, keyProvider);
        log.info("Message {} successfully decrypted.", (Object)msgId);
    }

    protected abstract IKeyProvider<Long, PgpDecryptionKey> createPgpKeyProvider();

    protected abstract IKeyProvider<KeyTransRecipientId, SmimeDecryptionKey> createSmimeKeyProvider();

    private IKeyProvider<Long, PgpDecryptionKey> getPgpKeyProvider() {
        if (this.pgpKeyProvider == null) {
            this.pgpKeyProvider = this.createPgpKeyProvider();
        }
        return this.pgpKeyProvider;
    }

    private IKeyProvider<KeyTransRecipientId, SmimeDecryptionKey> getSmimeKeyProvider() {
        if (this.smimeKeyProvider == null) {
            this.smimeKeyProvider = this.createSmimeKeyProvider();
        }
        return this.smimeKeyProvider;
    }

    private PgpMailDecryptor getPgpDecryptor() {
        if (this.pgpDecryptor == null) {
            this.pgpDecryptor = this.createPgpDecryptor();
        }
        return this.pgpDecryptor;
    }

    private SmimeMailDecryptor getSmimeDecryptor() {
        if (this.smimeDecryptor == null) {
            this.smimeDecryptor = this.createSmimeDecryptor();
        }
        return this.smimeDecryptor;
    }

    private PgpMailDecryptor createPgpDecryptor() {
        PgpMailDecryptor decryptor = new PgpMailDecryptor(this.getSession());
        decryptor.setProductInfo(this.info);
        if (this.isCheckPgpInline()) {
            decryptor.setCheckInline(true);
            decryptor.setBinaryRegex(this.getCheckPgpBinaryAttachment());
        }
        return decryptor;
    }

    private SmimeMailDecryptor createSmimeDecryptor() {
        SmimeMailDecryptor decryptor = new SmimeMailDecryptor(this.getSession());
        decryptor.setProductInfo(this.info);
        return decryptor;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public boolean isCheckPgpInline() {
        return this.checkPgpInline;
    }

    public void setCheckPgpInline(boolean checkPgpInline) {
        this.checkPgpInline = checkPgpInline;
    }

    public String getCheckPgpBinaryAttachment() {
        return this.checkPgpBinaryAttachment;
    }

    public void setCheckPgpBinaryAttachment(String checkPgpBinaryAttachment) {
        this.checkPgpBinaryAttachment = checkPgpBinaryAttachment;
    }

    @Override
    public boolean isWarning() {
        return this.warning;
    }

    protected void setWarning(boolean warning) {
        this.warning = warning;
    }
}

