/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.extract;

import jakarta.mail.Message;
import jakarta.mail.internet.MimeMessage;
import java.util.function.Supplier;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.key.ValidityKey;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.mail.visitor.extract.IMailExtractor;
import net.savignano.cryptography.mail.visitor.specific.DetectCryptographyVisitor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.snotify.jira.mailer.extract.IComposedMailExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposedMailExtractor
implements IComposedMailExtractor {
    private static final Logger log = LoggerFactory.getLogger(ComposedMailExtractor.class);
    private static final ValidityKey<?> NOT_FOUND_KEY = ValidityKey.key(EKeyValidity.NOT_FOUND, ECryptographyType.NONE);
    private final DetectCryptographyVisitor detectCrypt = new DetectCryptographyVisitor();
    private IMailExtractor<PgpEncryptionKey> pgpExtractor;
    private IMailExtractor<SmimeEncryptionKey> smimeExtractor;
    private Supplier<IMailExtractor<PgpEncryptionKey>> pgpExtractorSupplier;
    private Supplier<IMailExtractor<SmimeEncryptionKey>> smimeExtractorSupplier;
    private boolean checkPgpInline;

    @Override
    public IPublicCryptographyKey<?> extractPublicKey(MimeMessage msg) {
        try {
            this.detectCrypt.visit(msg);
        }
        catch (Exception e) {
            log.error("Could not detect cryptography of message with ID \"" + MessageUtil.getMessageId((Message)msg) + "\". No public key extraction will be tried. Error message: " + e.getMessage(), (Throwable)e);
        }
        switch ((ECryptographyType)((Object)this.detectCrypt.getResult())) {
            case PGP: {
                return this.extractPgpKey(msg);
            }
            case SMIME: {
                return this.extractSmimeKey(msg);
            }
        }
        return NOT_FOUND_KEY;
    }

    private IPublicCryptographyKey<?> extractPgpKey(MimeMessage msg) {
        IMailExtractor<PgpEncryptionKey> extractor = this.getPgpExtractor();
        if (extractor != null) {
            return extractor.extractPublicKey(msg);
        }
        return NOT_FOUND_KEY;
    }

    private IPublicCryptographyKey<?> extractSmimeKey(MimeMessage msg) {
        IMailExtractor<SmimeEncryptionKey> extractor = this.getSmimeExtractor();
        if (extractor != null) {
            return extractor.extractPublicKey(msg);
        }
        return NOT_FOUND_KEY;
    }

    public IMailExtractor<PgpEncryptionKey> getPgpExtractor() {
        if (this.pgpExtractor == null && this.pgpExtractorSupplier != null) {
            this.pgpExtractor = this.pgpExtractorSupplier.get();
        }
        return this.pgpExtractor;
    }

    public void setPgpExtractor(IMailExtractor<PgpEncryptionKey> extractor) {
        this.pgpExtractor = extractor;
    }

    public void setPgpExtractorSupplier(Supplier<IMailExtractor<PgpEncryptionKey>> supplier) {
        this.pgpExtractorSupplier = supplier;
    }

    public IMailExtractor<SmimeEncryptionKey> getSmimeExtractor() {
        if (this.smimeExtractor == null && this.smimeExtractorSupplier != null) {
            this.smimeExtractor = this.smimeExtractorSupplier.get();
        }
        return this.smimeExtractor;
    }

    public void setSmimeExtractor(IMailExtractor<SmimeEncryptionKey> extractor) {
        this.smimeExtractor = extractor;
    }

    public void setSmimeExtractorSupplier(Supplier<IMailExtractor<SmimeEncryptionKey>> supplier) {
        this.smimeExtractorSupplier = supplier;
    }

    public boolean isCheckPgpInline() {
        return this.checkPgpInline;
    }

    public void setCheckPgpInline(boolean checkPgpInline) {
        this.checkPgpInline = checkPgpInline;
    }

    static {
        NOT_FOUND_KEY.setKeySource(EKeySource.EMAIL);
    }
}

