/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.pop3;

import jakarta.mail.FetchProfile;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.search.SearchTerm;
import java.util.Arrays;
import net.savignano.cryptography.LazyLog;
import net.savignano.snotify.jira.mailer.pop3.Pop3MessageTransformer;
import org.eclipse.angus.mail.pop3.POP3Folder;
import org.eclipse.angus.mail.pop3.POP3Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASnotifyPop3Folder
extends POP3Folder {
    private static final Logger log = LoggerFactory.getLogger(ASnotifyPop3Folder.class);
    private final Pop3MessageTransformer transformer;
    private boolean currentlyFetching;

    protected ASnotifyPop3Folder(POP3Store store, String name) {
        super(store, name);
        log.trace("S/Notify POP3 Folder implementation: {}", (Object)((Object)((Object)this)).getClass().getName());
        this.transformer = this.createMessageTransformer();
        if (this.transformer == null) {
            throw new IllegalStateException("Transformer must not be null.");
        }
    }

    public synchronized Message getMessage(int msgnum) throws MessagingException {
        log.trace("S/Notify POP3 folder method called to retrieve messages: getMessage({})", (Object)msgnum);
        Message orgMsg = super.getMessage(msgnum);
        if (this.currentlyFetching) {
            return orgMsg;
        }
        return this.transformer.transformMessage(orgMsg);
    }

    public synchronized Message[] search(SearchTerm term) throws MessagingException {
        log.trace("S/Notify POP3 folder method called to retrieve messages: search({})", (Object)term);
        Message[] orgMsgs = super.search(term);
        return this.transformer.transformMessages(orgMsgs);
    }

    public synchronized Message[] search(SearchTerm term, Message[] msgs) throws MessagingException {
        log.trace("S/Notify POP3 folder method called to retrieve messages: search({}, {})", (Object)term, (Object)new LazyLog(() -> Arrays.toString(msgs)));
        Message[] orgMsgs = super.search(term, msgs);
        return this.transformer.transformMessages(orgMsgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void fetch(Message[] msgs, FetchProfile fp) throws MessagingException {
        log.trace("S/Notify POP3 folder method called to change messages: fetch({}, {})", (Object)new LazyLog(() -> Arrays.toString(msgs)), (Object)fp);
        Message[] pop3Msgs = this.transformer.unwrap(msgs);
        try {
            this.currentlyFetching = true;
            super.fetch(pop3Msgs, fp);
        }
        finally {
            this.currentlyFetching = false;
        }
    }

    public synchronized String getUID(Message msg) throws MessagingException {
        log.trace("S/Notify POP3 folder method called to change messages: getUID({})", (Object)msg);
        Message pop3Msg = this.transformer.unwrap(msg);
        return super.getUID(pop3Msg);
    }

    protected abstract Pop3MessageTransformer createMessageTransformer();
}

