/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.pop3;

import jakarta.mail.Flags;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.search.SearchTerm;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.jira.mailer.AtlassianIncomingMailHandler;
import net.savignano.snotify.jira.mailer.pop3.ASnotifyPop3Folder;
import net.savignano.snotify.jira.mailer.pop3.Pop3MessageTransformer;
import net.savignano.snotify.jira.mailer.util.PropertiesUtil;
import org.eclipse.angus.mail.pop3.POP3Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyPop3Folder
extends ASnotifyPop3Folder {
    private static final Logger log = LoggerFactory.getLogger(SnotifyPop3Folder.class);

    protected SnotifyPop3Folder(POP3Store store, String name) {
        super(store, name);
        log.debug("Using S/Notify POP3 Folder implementation to receive emails.");
    }

    @Override
    public synchronized Message getMessage(int msgnum) throws MessagingException {
        Message msg = super.getMessage(msgnum);
        this.expungeDoNotSend(msg);
        return msg;
    }

    @Override
    public synchronized Message[] search(SearchTerm term) throws MessagingException {
        Message[] msgs = super.search(term);
        this.expungeDoNotSend(msgs);
        return msgs;
    }

    @Override
    public synchronized Message[] search(SearchTerm term, Message[] msgs) throws MessagingException {
        Message[] messages = super.search(term, msgs);
        this.expungeDoNotSend(messages);
        return messages;
    }

    private void expungeDoNotSend(Message ... msgs) throws MessagingException {
        if (msgs == null || this.mode != 2) {
            return;
        }
        for (Message msg : msgs) {
            String[] header;
            if (msg == null || (header = msg.getHeader("X-Do-Not-Send")) == null || header.length == 0 || !Boolean.parseBoolean(header[0])) continue;
            log.info("Message with ID {} has a 'do not send'-header of S/Notify. This message should not be here and will be deleted.", (Object)MessageUtil.getMessageId(msg));
            msg.setFlag(Flags.Flag.DELETED, true);
        }
    }

    @Override
    protected Pop3MessageTransformer createMessageTransformer() {
        ISnotifyAppProperties appProps = this.getAppProps();
        AtlassianIncomingMailHandler handler = new AtlassianIncomingMailHandler(appProps, this.getUserProps());
        return new Pop3MessageTransformer(handler.createConfiguration());
    }

    private ISnotifyAppProperties getAppProps() {
        return PropertiesUtil.getAppProps();
    }

    private ISnotifyUserProperties getUserProps() {
        return PropertiesUtil.getUserProps();
    }
}

