/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.validate;

import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.enums.EValidationType;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.pgp.PgpValidationKey;
import net.savignano.cryptography.mail.validate.PgpMailValidator;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;

public class AtlassianPgpMailValidator
extends PgpMailValidator {
    private BiFunction<Long, String, ICryptographyKey<PGPPublicKey>> userKeyRetriever = (id, email) -> new PgpValidationKey(EKeyValidity.NOT_FOUND);

    public AtlassianPgpMailValidator(Session session) {
        super(session);
    }

    public BiFunction<Long, String, ICryptographyKey<PGPPublicKey>> getUserKeyRetriever() {
        return this.userKeyRetriever;
    }

    public void setUserKeyRetriever(BiFunction<Long, String, ICryptographyKey<PGPPublicKey>> userKeyRetriever) {
        this.userKeyRetriever = userKeyRetriever;
        if (userKeyRetriever == null) {
            throw new IllegalArgumentException("Function must not be null.");
        }
    }

    @Override
    protected Set<EValidationType> doValidate(MimeMessage msg) throws Exception {
        Optional<String> email = MessageUtil.getFromEmail(msg);
        PgpMailValidator.ValidateVisitor visitor = new PgpMailValidator.ValidateVisitor(this.getCombinedValidationKeyRetriever(email), this.getSession(), this.isCheckInline());
        visitor.visit(msg);
        return (Set)visitor.getResult();
    }

    private Function<Long, ICryptographyKey<PGPPublicKey>> getCombinedValidationKeyRetriever(Optional<String> email) {
        return id -> {
            ICryptographyKey key = this.getValidationKeyRetriever().apply((Long)id);
            if (key.isValid() || !email.isPresent()) {
                return key;
            }
            return this.userKeyRetriever.apply((Long)id, (String)email.get());
        };
    }
}

