/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmp;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KemBMParameter
extends ASN1Object {
    private final AlgorithmIdentifier kdf;
    private final ASN1Integer len;
    private final AlgorithmIdentifier mac;

    private KemBMParameter(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("sequence size should 3");
        }
        this.kdf = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        this.len = ASN1Integer.getInstance(seq.getObjectAt(1));
        this.mac = AlgorithmIdentifier.getInstance(seq.getObjectAt(2));
    }

    public KemBMParameter(AlgorithmIdentifier kdf, ASN1Integer len, AlgorithmIdentifier mac) {
        this.kdf = kdf;
        this.len = len;
        this.mac = mac;
    }

    public KemBMParameter(AlgorithmIdentifier kdf, long len, AlgorithmIdentifier mac) {
        this(kdf, new ASN1Integer(len), mac);
    }

    public static KemBMParameter getInstance(Object o) {
        if (o instanceof KemBMParameter) {
            return (KemBMParameter)o;
        }
        if (o != null) {
            return new KemBMParameter(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public AlgorithmIdentifier getKdf() {
        return this.kdf;
    }

    public ASN1Integer getLen() {
        return this.len;
    }

    public AlgorithmIdentifier getMac() {
        return this.mac;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        v.add(this.kdf);
        v.add(this.len);
        v.add(this.mac);
        return new DERSequence(v);
    }
}

