/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric;

import java.util.HashMap;
import java.util.Map;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.CompositeSignaturesConstants;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.KeyFactorySpi;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.util.AsymmetricAlgorithmProvider;

public class CompositeSignatures {
    private static final String PREFIX = "net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.";
    private static final Map<String, String> compositesAttributes = new HashMap<String, String>();

    static {
        compositesAttributes.put("SupportedKeyClasses", "net.savignano.thirdparty.org.bouncycastle.jcajce.CompositePublicKey|net.savignano.thirdparty.org.bouncycastle.jcajce.CompositePrivateKey");
        compositesAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
    }

    public static class Mappings
    extends AsymmetricAlgorithmProvider {
        @Override
        public void configure(ConfigurableProvider provider) {
            for (ASN1ObjectIdentifier oid : CompositeSignaturesConstants.supportedIdentifiers) {
                CompositeSignaturesConstants.CompositeName algName = CompositeSignaturesConstants.ASN1IdentifierAlgorithmNameMap.get(oid);
                provider.addAlgorithm("KeyFactory." + algName.getId(), "net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.KeyFactorySpi");
                provider.addAlgorithm("Alg.Alias.KeyFactory", oid, algName.getId());
                provider.addAlgorithm("KeyPairGenerator." + algName.getId(), "net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.KeyPairGeneratorSpi$" + (Object)((Object)algName));
                provider.addAlgorithm("Alg.Alias.KeyPairGenerator", oid, algName.getId());
                provider.addAlgorithm("Signature." + algName.getId(), "net.savignano.thirdparty.org.bouncycastle.jcajce.provider.asymmetric.compositesignatures.SignatureSpi$" + (Object)((Object)algName));
                provider.addAlgorithm("Alg.Alias.Signature", oid, algName.getId());
                provider.addKeyInfoConverter(oid, new KeyFactorySpi());
            }
        }
    }
}

