/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.AEADEncDataPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.InputStreamPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPKeyValidationException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSessionKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class PGPPublicKeyEncryptedData
extends PGPEncryptedData {
    PublicKeyEncSessionPacket keyData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket keyData, InputStreamPacket encData) {
        super(encData);
        this.keyData = keyData;
    }

    private boolean confirmCheckSum(byte[] sessionInfo) {
        int check = 0;
        for (int i = 1; i != sessionInfo.length - 2; ++i) {
            check += sessionInfo[i] & 0xFF;
        }
        return sessionInfo[sessionInfo.length - 2] == (byte)(check >> 8) && sessionInfo[sessionInfo.length - 1] == (byte)check;
    }

    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public int getSymmetricAlgorithm(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        if (this.keyData.getVersion() == 3) {
            byte[] plain = dataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
            return plain[0];
        }
        if (this.keyData.getVersion() == 6) {
            return ((SymmetricEncIntegrityPacket)this.encData).getCipherAlgorithm();
        }
        throw new UnsupportedPacketVersionException("Unsupported packet version: " + this.keyData.getVersion());
    }

    public PGPSessionKey getSessionKey(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        byte[] sessionData = dataDecryptorFactory.recoverSessionData(this.keyData.getAlgorithm(), this.keyData.getEncSessionKey());
        if (this.keyData.getAlgorithm() == 25 || this.keyData.getAlgorithm() == 26) {
            return new PGPSessionKey(sessionData[0] & 0xFF, Arrays.copyOfRange(sessionData, 1, sessionData.length));
        }
        if (!this.confirmCheckSum(sessionData)) {
            throw new PGPKeyValidationException("key checksum failed");
        }
        return new PGPSessionKey(sessionData[0] & 0xFF, Arrays.copyOfRange(sessionData, 1, sessionData.length - 2));
    }

    public InputStream getDataStream(PublicKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        return this.getDataStream(dataDecryptorFactory, this.getSessionKey(dataDecryptorFactory));
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        return this.getDataStream(dataDecryptorFactory, dataDecryptorFactory.getSessionKey());
    }

    private InputStream getDataStream(PGPDataDecryptorFactory dataDecryptorFactory, PGPSessionKey sessionKey) throws PGPException {
        if (sessionKey.getAlgorithm() != 0) {
            try {
                if (this.encData instanceof AEADEncDataPacket) {
                    AEADEncDataPacket aeadData = (AEADEncDataPacket)this.encData;
                    if (aeadData.getAlgorithm() != sessionKey.getAlgorithm()) {
                        throw new PGPException("session key and AEAD algorithm mismatch");
                    }
                    PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(aeadData, sessionKey);
                    BCPGInputStream encIn = this.encData.getInputStream();
                    this.encStream = new BCPGInputStream(dataDecryptor.getInputStream(encIn));
                } else {
                    boolean withIntegrityPacket = this.encData instanceof SymmetricEncIntegrityPacket;
                    PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(withIntegrityPacket, sessionKey.getAlgorithm(), sessionKey.getKey());
                    BCPGInputStream encIn = this.encData.getInputStream();
                    this.processSymmetricEncIntegrityPacketDataStream(withIntegrityPacket, dataDecryptor, encIn);
                }
                return this.encStream;
            }
            catch (PGPException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PGPException("Exception starting decryption", e);
            }
        }
        return this.encData.getInputStream();
    }

    @Override
    public int getAlgorithm() {
        return this.keyData.getAlgorithm();
    }

    @Override
    public int getVersion() {
        return this.keyData.getVersion();
    }
}

