/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SignaturePacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SignatureSubpacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.Exportable;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.Features;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.IssuerFingerprint;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.IssuerKeyID;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.KeyExpirationTime;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.KeyFlags;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.NotationData;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.PolicyURI;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.PrimaryUserID;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.RegularExpression;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.Revocable;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.RevocationKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.RevocationReason;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.SignatureCreationTime;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.SignatureTarget;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.SignerUserID;
import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.TrustSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureList;

public class PGPSignatureSubpacketVector {
    SignatureSubpacket[] packets;

    public static PGPSignatureSubpacketVector fromSubpackets(SignatureSubpacket[] packets) {
        if (packets == null) {
            packets = new SignatureSubpacket[]{};
        }
        return new PGPSignatureSubpacketVector(packets);
    }

    PGPSignatureSubpacketVector(SignatureSubpacket[] packets) {
        this.packets = packets;
    }

    public SignatureSubpacket getSubpacket(int type) {
        for (int i = 0; i != this.packets.length; ++i) {
            if (this.packets[i].getType() != type) continue;
            return this.packets[i];
        }
        return null;
    }

    public boolean hasSubpacket(int type) {
        return this.getSubpacket(type) != null;
    }

    public SignatureSubpacket[] getSubpackets(int type) {
        ArrayList<SignatureSubpacket> list = new ArrayList<SignatureSubpacket>();
        for (int i = 0; i != this.packets.length; ++i) {
            if (this.packets[i].getType() != type) continue;
            list.add(this.packets[i]);
        }
        return list.toArray(new SignatureSubpacket[0]);
    }

    public PGPSignatureList getEmbeddedSignatures() throws PGPException {
        SignatureSubpacket[] sigs = this.getSubpackets(32);
        ArrayList<PGPSignature> l = new ArrayList<PGPSignature>();
        for (int i = 0; i < sigs.length; ++i) {
            try {
                l.add(new PGPSignature(SignaturePacket.fromByteArray(sigs[i].getData())));
                continue;
            }
            catch (IOException e) {
                throw new PGPException("Unable to parse signature packet: " + e.getMessage(), e);
            }
        }
        return new PGPSignatureList(l.toArray(new PGPSignature[l.size()]));
    }

    public NotationData[] getNotationDataOccurrences() {
        SignatureSubpacket[] notations = this.getSubpackets(20);
        NotationData[] vals = new NotationData[notations.length];
        for (int i = 0; i < notations.length; ++i) {
            vals[i] = (NotationData)notations[i];
        }
        return vals;
    }

    public NotationData[] getNotationDataOccurences() {
        return this.getNotationDataOccurrences();
    }

    public NotationData[] getNotationDataOccurrences(String notationName) {
        NotationData[] notations = this.getNotationDataOccurrences();
        ArrayList<NotationData> notationsWithName = new ArrayList<NotationData>();
        for (int i = 0; i != notations.length; ++i) {
            NotationData notation = notations[i];
            if (!notation.getNotationName().equals(notationName)) continue;
            notationsWithName.add(notation);
        }
        return notationsWithName.toArray(new NotationData[0]);
    }

    public long getIssuerKeyID() {
        SignatureSubpacket p = this.getSubpacket(16);
        if (p == null) {
            return 0L;
        }
        return ((IssuerKeyID)p).getKeyID();
    }

    public Date getSignatureCreationTime() {
        SignatureSubpacket p = this.getSubpacket(2);
        if (p == null) {
            return null;
        }
        return ((SignatureCreationTime)p).getTime();
    }

    public long getSignatureExpirationTime() {
        SignatureSubpacket p = this.getSubpacket(3);
        if (p == null) {
            return 0L;
        }
        return ((SignatureExpirationTime)p).getTime();
    }

    public long getKeyExpirationTime() {
        SignatureSubpacket p = this.getSubpacket(9);
        if (p == null) {
            return 0L;
        }
        return ((KeyExpirationTime)p).getTime();
    }

    public int[] getPreferredHashAlgorithms() {
        SignatureSubpacket p = this.getSubpacket(21);
        if (p == null) {
            return null;
        }
        return ((PreferredAlgorithms)p).getPreferences();
    }

    public int[] getPreferredSymmetricAlgorithms() {
        SignatureSubpacket p = this.getSubpacket(11);
        if (p == null) {
            return null;
        }
        return ((PreferredAlgorithms)p).getPreferences();
    }

    public int[] getPreferredCompressionAlgorithms() {
        SignatureSubpacket p = this.getSubpacket(22);
        if (p == null) {
            return null;
        }
        return ((PreferredAlgorithms)p).getPreferences();
    }

    public int[] getPreferredAEADAlgorithms() {
        SignatureSubpacket p = this.getSubpacket(39);
        if (p == null) {
            return null;
        }
        return ((PreferredAlgorithms)p).getPreferences();
    }

    public int getKeyFlags() {
        SignatureSubpacket p = this.getSubpacket(27);
        if (p == null) {
            return 0;
        }
        return ((KeyFlags)p).getFlags();
    }

    public String getSignerUserID() {
        SignatureSubpacket p = this.getSubpacket(28);
        if (p == null) {
            return null;
        }
        return ((SignerUserID)p).getID();
    }

    public boolean isPrimaryUserID() {
        PrimaryUserID primaryId = (PrimaryUserID)this.getSubpacket(25);
        if (primaryId != null) {
            return primaryId.isPrimaryUserID();
        }
        return false;
    }

    public int[] getCriticalTags() {
        int count = 0;
        for (int i = 0; i != this.packets.length; ++i) {
            if (!this.packets[i].isCritical()) continue;
            ++count;
        }
        int[] list = new int[count];
        count = 0;
        for (int i = 0; i != this.packets.length; ++i) {
            if (!this.packets[i].isCritical()) continue;
            list[count++] = this.packets[i].getType();
        }
        return list;
    }

    public SignatureTarget getSignatureTarget() {
        SignatureSubpacket p = this.getSubpacket(31);
        if (p == null) {
            return null;
        }
        return new SignatureTarget(p.isCritical(), p.isLongLength(), p.getData());
    }

    public Features getFeatures() {
        SignatureSubpacket p = this.getSubpacket(30);
        if (p == null) {
            return null;
        }
        return new Features(p.isCritical(), p.isLongLength(), p.getData());
    }

    public IssuerFingerprint getIssuerFingerprint() {
        SignatureSubpacket p = this.getSubpacket(33);
        if (p == null) {
            return null;
        }
        return new IssuerFingerprint(p.isCritical(), p.isLongLength(), p.getData());
    }

    public IntendedRecipientFingerprint getIntendedRecipientFingerprint() {
        SignatureSubpacket p = this.getSubpacket(35);
        if (p == null) {
            return null;
        }
        return new IntendedRecipientFingerprint(p.isCritical(), p.isLongLength(), p.getData());
    }

    public IntendedRecipientFingerprint[] getIntendedRecipientFingerprints() {
        SignatureSubpacket[] subpackets = this.getSubpackets(35);
        IntendedRecipientFingerprint[] recipients = new IntendedRecipientFingerprint[subpackets.length];
        for (int i = 0; i < recipients.length; ++i) {
            recipients[i] = new IntendedRecipientFingerprint(subpackets[i].isCritical(), subpackets[i].isLongLength(), subpackets[i].getData());
        }
        return recipients;
    }

    public Exportable getExportable() {
        SignatureSubpacket p = this.getSubpacket(4);
        if (p == null) {
            return null;
        }
        return new Exportable(p.isCritical(), p.isLongLength(), p.getData());
    }

    public boolean isExportable() {
        Exportable exportable = this.getExportable();
        return exportable == null || exportable.isExportable();
    }

    public PolicyURI getPolicyURI() {
        SignatureSubpacket p = this.getSubpacket(26);
        if (p == null) {
            return null;
        }
        return new PolicyURI(p.isCritical(), p.isLongLength(), p.getData());
    }

    public PolicyURI[] getPolicyURIs() {
        SignatureSubpacket[] subpackets = this.getSubpackets(26);
        PolicyURI[] policyURIS = new PolicyURI[subpackets.length];
        for (int i = 0; i < subpackets.length; ++i) {
            SignatureSubpacket p = subpackets[i];
            policyURIS[i] = new PolicyURI(p.isCritical(), p.isLongLength(), p.getData());
        }
        return policyURIS;
    }

    public RegularExpression getRegularExpression() {
        SignatureSubpacket p = this.getSubpacket(6);
        if (p == null) {
            return null;
        }
        return new RegularExpression(p.isCritical(), p.isLongLength(), p.getData());
    }

    public RegularExpression[] getRegularExpressions() {
        SignatureSubpacket[] subpackets = this.getSubpackets(6);
        RegularExpression[] regexes = new RegularExpression[subpackets.length];
        for (int i = 0; i < regexes.length; ++i) {
            SignatureSubpacket p = subpackets[i];
            regexes[i] = new RegularExpression(p.isCritical(), p.isLongLength(), p.getData());
        }
        return regexes;
    }

    public Revocable getRevocable() {
        SignatureSubpacket p = this.getSubpacket(7);
        if (p == null) {
            return null;
        }
        return new Revocable(p.isCritical(), p.isLongLength(), p.getData());
    }

    public boolean isRevocable() {
        Revocable revocable = this.getRevocable();
        return revocable == null || revocable.isRevocable();
    }

    public RevocationKey[] getRevocationKeys() {
        SignatureSubpacket[] subpackets = this.getSubpackets(12);
        RevocationKey[] revocationKeys = new RevocationKey[subpackets.length];
        for (int i = 0; i < revocationKeys.length; ++i) {
            revocationKeys[i] = new RevocationKey(subpackets[i].isCritical(), subpackets[i].isLongLength(), subpackets[i].getData());
        }
        return revocationKeys;
    }

    public RevocationReason getRevocationReason() {
        SignatureSubpacket p = this.getSubpacket(29);
        if (p == null) {
            return null;
        }
        return new RevocationReason(p.isCritical(), p.isLongLength(), p.getData());
    }

    public TrustSignature getTrust() {
        SignatureSubpacket p = this.getSubpacket(5);
        if (p == null) {
            return null;
        }
        return new TrustSignature(p.isCritical(), p.isLongLength(), p.getData());
    }

    public int size() {
        return this.packets.length;
    }

    SignatureSubpacket[] toSubpacketArray() {
        return this.packets;
    }

    public SignatureSubpacket[] toArray() {
        SignatureSubpacket[] rv = new SignatureSubpacket[this.packets.length];
        System.arraycopy(this.packets, 0, rv, 0, rv.length);
        return rv;
    }
}

