/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.asn1;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.pqc.asn1.FalconPublicKey;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class FalconPrivateKey
extends ASN1Object {
    private int version;
    private byte[] f;
    private byte[] g;
    private byte[] F;
    private FalconPublicKey publicKey;

    public FalconPrivateKey(int version, byte[] f, byte[] g, byte[] f1, FalconPublicKey publicKey) {
        this.version = version;
        this.f = f;
        this.g = g;
        this.F = f1;
        this.publicKey = publicKey;
    }

    public FalconPrivateKey(int version, byte[] f, byte[] g, byte[] f1) {
        this(version, f, g, f1, null);
    }

    public int getVersion() {
        return this.version;
    }

    public byte[] getf() {
        return Arrays.clone(this.f);
    }

    public byte[] getF() {
        return Arrays.clone(this.F);
    }

    public FalconPublicKey getPublicKey() {
        return this.publicKey;
    }

    public byte[] getG() {
        return Arrays.clone(this.g);
    }

    private FalconPrivateKey(ASN1Sequence seq) {
        this.version = ASN1Integer.getInstance(seq.getObjectAt(0)).intValueExact();
        if (this.version != 0) {
            throw new IllegalArgumentException("unrecognized version");
        }
        this.f = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
        this.g = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets());
        this.F = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(3)).getOctets());
        if (seq.size() == 5) {
            this.publicKey = FalconPublicKey.getInstance(seq.getObjectAt(4));
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.version));
        v.add(new DEROctetString(this.f));
        v.add(new DEROctetString(this.g));
        v.add(new DEROctetString(this.F));
        if (this.publicKey != null) {
            v.add(new FalconPublicKey(this.publicKey.getH()));
        }
        return new DERSequence(v);
    }

    public static FalconPrivateKey getInstance(Object o) {
        if (o instanceof FalconPrivateKey) {
            return (FalconPrivateKey)o;
        }
        if (o != null) {
            return new FalconPrivateKey(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

