/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA256Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHAKEDigest;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSigParameters;

class DigestUtil {
    DigestUtil() {
    }

    static Digest getDigest(LMOtsParameters otsParameters) {
        return DigestUtil.createDigest(otsParameters.getDigestOID(), otsParameters.getN());
    }

    static Digest getDigest(LMSigParameters sigParameters) {
        return DigestUtil.createDigest(sigParameters.getDigestOID(), sigParameters.getM());
    }

    private static Digest createDigest(ASN1ObjectIdentifier oid, int length) {
        Digest digest = DigestUtil.createDigest(oid);
        if (NISTObjectIdentifiers.id_shake256_len.equals(oid) || digest.getDigestSize() != length) {
            return new WrapperDigest(digest, length);
        }
        return digest;
    }

    private static Digest createDigest(ASN1ObjectIdentifier oid) {
        if (oid.equals(NISTObjectIdentifiers.id_sha256)) {
            return new SHA256Digest();
        }
        if (oid.equals(NISTObjectIdentifiers.id_shake256_len)) {
            return new SHAKEDigest(256);
        }
        throw new IllegalArgumentException("unrecognized digest OID: " + oid);
    }

    static class WrapperDigest
    implements Digest {
        private final Digest digest;
        private final int length;

        WrapperDigest(Digest digest, int length) {
            this.digest = digest;
            this.length = length;
        }

        @Override
        public String getAlgorithmName() {
            return this.digest.getAlgorithmName() + "/" + this.length * 8;
        }

        @Override
        public int getDigestSize() {
            return this.length;
        }

        @Override
        public void update(byte in) {
            this.digest.update(in);
        }

        @Override
        public void update(byte[] in, int inOff, int len) {
            this.digest.update(in, inOff, len);
        }

        @Override
        public int doFinal(byte[] out, int outOff) {
            byte[] digOut = new byte[this.digest.getDigestSize()];
            this.digest.doFinal(digOut, 0);
            System.arraycopy(digOut, 0, out, outOff, this.length);
            return this.length;
        }

        @Override
        public void reset() {
            this.digest.reset();
        }
    }
}

