/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xwing;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xwing.XWingPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xwing.XWingPublicKeyParameters;

public class XWingKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private SecureRandom random;

    private void initialize(KeyGenerationParameters param) {
        this.random = param.getRandom();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        KyberKeyPairGenerator kyberKeyGen = new KyberKeyPairGenerator();
        kyberKeyGen.init(new KyberKeyGenerationParameters(this.random, KyberParameters.kyber768));
        X25519KeyPairGenerator x25519KeyGen = new X25519KeyPairGenerator();
        x25519KeyGen.init(new X25519KeyGenerationParameters(this.random));
        AsymmetricCipherKeyPair kybKp = kyberKeyGen.generateKeyPair();
        AsymmetricCipherKeyPair xdhKp = x25519KeyGen.generateKeyPair();
        return new AsymmetricCipherKeyPair(new XWingPublicKeyParameters(kybKp.getPublic(), xdhKp.getPublic()), new XWingPrivateKeyParameters(kybKp.getPrivate(), xdhKp.getPrivate()));
    }

    @Override
    public void init(KeyGenerationParameters param) {
        this.initialize(param);
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

