/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.rainbow;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.interfaces.RainbowPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.RainbowParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class BCRainbowPublicKey
implements RainbowPublicKey {
    private static final long serialVersionUID = 1L;
    private transient RainbowPublicKeyParameters params;
    private transient String algorithm;
    private transient byte[] encoding;

    public BCRainbowPublicKey(RainbowPublicKeyParameters params) {
        this.init(params);
    }

    public BCRainbowPublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init((RainbowPublicKeyParameters)PublicKeyFactory.createKey(keyInfo));
    }

    private void init(RainbowPublicKeyParameters params) {
        this.params = params;
        this.algorithm = Strings.toUpperCase(params.getParameters().getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCRainbowPublicKey) {
            BCRainbowPublicKey otherKey = (BCRainbowPublicKey)o;
            return Arrays.areEqual(this.getEncoded(), otherKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = KeyUtil.getEncodedSubjectPublicKeyInfo(this.params);
        }
        return Arrays.clone(this.encoding);
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public RainbowParameterSpec getParameterSpec() {
        return RainbowParameterSpec.fromName(this.params.getParameters().getName());
    }

    RainbowPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

