/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.ValidityKeyFactory;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.StaticKeyLoader;

public class CompoundKeyLoader<T extends ICryptographyKey<?>, U>
extends AKeyLoader<T, U> {
    public static final int INFO_QUERY_KEY_LOADER = 900;
    private final List<Supplier<IKeyLoader<T, U>>> suppliers = new ArrayList<Supplier<IKeyLoader<T, U>>>(0);
    private final BiFunction<EKeyValidity, EKeySource, T> validityKeyFunction;
    private final ECryptographyType cryptography;
    private final List<IKeyLoader<T, U>> loaders = new ArrayList<IKeyLoader<T, U>>(0);

    public static final <T extends ICryptographyKey<?>> BiFunction<EKeyValidity, EKeySource, T> validityKeyFromFactory(Class<T> keyType) {
        return (validity, source) -> ValidityKeyFactory.getInstance().create(keyType, (EKeyValidity)((Object)validity), (EKeySource)((Object)source));
    }

    public CompoundKeyLoader(Class<T> keyType) {
        this(CompoundKeyLoader.validityKeyFromFactory(keyType));
    }

    public CompoundKeyLoader(BiFunction<EKeyValidity, EKeySource, T> createValidityKey) {
        this.validityKeyFunction = createValidityKey;
        this.cryptography = this.getValidityKey(EKeyValidity.NOT_FOUND).getCryptography();
    }

    @Override
    protected T loadInternalKey(U forId) throws Exception {
        T key;
        ICryptographyKey bestKey = null;
        int i = 0;
        for (IKeyLoader<T, U> loader : this.loaders) {
            this.getInfoDataManager().send(new InfoData(900, new Object[]{i++, loader.getKeySource()}));
            key = this.loadKey(loader, forId);
            if (!(bestKey = this.chooseBetterKey(bestKey, key)).isValid()) continue;
            break;
        }
        if (bestKey == null || !bestKey.isValid()) {
            Iterator<Supplier<IKeyLoader<T, U>>> iter = this.suppliers.iterator();
            while (iter.hasNext()) {
                IKeyLoader<T, U> loader;
                loader = this.loadLoader(iter.next());
                this.loaders.add(loader);
                iter.remove();
                this.getInfoDataManager().send(new InfoData(900, new Object[]{i++, loader.getKeySource()}));
                key = this.loadKey(loader, forId);
                if (!(bestKey = this.chooseBetterKey(bestKey, key)).isValid()) continue;
                break;
            }
        }
        if (bestKey == null) {
            bestKey = this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        return (T)bestKey;
    }

    private IKeyLoader<T, U> loadLoader(Supplier<IKeyLoader<T, U>> supplier) {
        try {
            this.getLog().debug("Creating loader.");
            return supplier.get();
        }
        catch (Exception e) {
            this.getLog().error("Unexpected error creating loader. Error message: " + e.getMessage(), (Throwable)e);
            return StaticKeyLoader.transform(this.getValidityKey(EKeyValidity.ERROR));
        }
    }

    private T loadKey(IKeyLoader<T, U> loader, U forId) {
        try {
            this.getLog().debug("Loading key from location: {}", (Object)loader.getKeySource());
            return loader.loadKey(forId);
        }
        catch (Exception e) {
            this.getLog().error("Unexpected error retrieving key from: " + loader + ". Error message: " + e.getMessage(), (Throwable)e);
            return (T)((ICryptographyKey)this.validityKeyFunction.apply(EKeyValidity.ERROR, loader.getKeySource()));
        }
    }

    private T chooseBetterKey(T bestKey, T key) {
        if (bestKey == null) {
            return key;
        }
        if (key == null) {
            return bestKey;
        }
        if (key.getKeyValidity().compareTo(bestKey.getKeyValidity()) < 0) {
            return key;
        }
        return bestKey;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.UNKNOWN;
    }

    @Override
    public ECryptographyType getCryptography() {
        return this.cryptography;
    }

    @Override
    protected T getValidityKey(EKeyValidity validity) {
        return (T)((ICryptographyKey)this.validityKeyFunction.apply(validity, EKeySource.UNKNOWN));
    }

    public List<Supplier<IKeyLoader<T, U>>> getKeyLoaderSuppliers() {
        return this.suppliers;
    }

    public List<IKeyLoader<T, U>> getKeyLoaders() {
        return this.loaders;
    }
}

