/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.pgp;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.pgp.PgpSignKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.slf4j.Logger;

public class PgpSignKeyStoreLoader
extends AKeyLoader<PgpSignKey, String> {
    public static final int INFO_NO_KEY_STORE = 200;
    public static final int INFO_NO_EMAIL = 201;
    public static final int INFO_EMAIL_FOUND = 202;
    public static final int INFO_EMAIL_NOT_FOUND = 203;
    private final PGPSecretKeyRingCollection keyRings;
    private final char[] password;

    public PgpSignKeyStoreLoader(PGPSecretKeyRingCollection keyRings, char[] password) {
        this.keyRings = keyRings;
        this.password = password;
    }

    @Override
    protected PgpSignKey loadInternalKey(String email) throws Exception {
        if (this.keyRings == null) {
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (email == null) {
            this.getInfoDataManager().send(new InfoData(201, new Object[0]));
            throw new IllegalArgumentException("Email must not be null.");
        }
        Logger log = this.getLog();
        log.info("Looking up PGP private key for email <{}> in key rings.", (Object)email);
        PGPSecretKeyRing keyRing = PgpUtil.getKeysForEmail(this.getKeyRings(), email);
        if (keyRing != null) {
            log.info("Found valid PGP private key ring for email <{}> in key store.", (Object)email);
            log.trace("Found PGP private key ring: {}", (Object)keyRing);
            this.getInfoDataManager().send(new InfoData(202, email));
            PgpSignKey key = new PgpSignKey(keyRing, this.password, email);
            key.setKeySource(this.getKeySource());
            return key;
        }
        log.info("Found no PGP private key for email <{}> in key store.", (Object)email);
        this.getInfoDataManager().send(new InfoData(203, email));
        return this.getValidityKey(EKeyValidity.NOT_FOUND);
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected PgpSignKey getValidityKey(EKeyValidity validity) {
        return new PgpSignKey(validity, this.getKeySource());
    }

    public PGPSecretKeyRingCollection getKeyRings() {
        return this.keyRings;
    }

    public String toString() {
        return "PgpSignKeyStoreLoader [keyRings=" + this.keyRings + ", password=*****]";
    }
}

