/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.util;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Header;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.savignano.cryptography.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtil {
    private static final Logger log = LoggerFactory.getLogger(MessageUtil.class);
    private static final Pattern RECEIVED_EMAIL_PATTERN = Pattern.compile("^from\\s.*\\sfor\\s<?([^@>;\\s]++@[^>;\\s]++)>?\\s*+;", 32);

    public static final MimeMessage copyMsg(MimeMessage source) throws IOException, MessagingException {
        if (source == null) {
            return null;
        }
        MimeMessage copy = new MimeMessage(source);
        return copy;
    }

    public static final MimeMessage copyMsg(MimeMessage source, Session session) throws IOException, MessagingException {
        if (source == null || session == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        source.writeTo((OutputStream)os);
        MimeMessage copy = new MimeMessage(session, (InputStream)new ByteArrayInputStream(os.toByteArray()));
        return copy;
    }

    public static final void overwriteMsg(MimeMessage source, MimeMessage destination) throws IOException, MessagingException {
        if (source == null || destination == null) {
            return;
        }
        MimeMessage copy = MessageUtil.copyMsg(source);
        MessageUtil.removeHeaders((Part)destination, destination.getAllHeaders());
        MessageUtil.movePart((Part)copy, (Part)destination);
        MessageUtil.copyHeaders((Part)destination, copy.getNonMatchingHeaders(Constants.STRUCTURAL_MIME_HEADERS));
        destination.saveChanges();
        MessageUtil.copyHeaders((Part)destination, copy.getMatchingHeaders(new String[]{"Message-ID"}));
    }

    public static final void trace(Message msg, String prefix, Logger log) {
        Logger usedLog;
        Logger logger = usedLog = log != null ? log : MessageUtil.log;
        if (usedLog.isTraceEnabled()) {
            if (msg == null) {
                usedLog.trace("Null message cannot be traced.");
                return;
            }
            try {
                ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)debugBaos);
                usedLog.trace("{}\n{}\n", (Object)(prefix != null ? prefix : ""), (Object)debugBaos.toString());
            }
            catch (Exception e) {
                usedLog.warn("Failed to output email with ID \"" + MessageUtil.getMessageId(msg) + "\". Error message: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static final Optional<Address> getFrom(MimeMessage msg) {
        Address[] addresses;
        String msgId = MessageUtil.getMessageId((Message)msg);
        try {
            addresses = msg.getFrom();
        }
        catch (MessagingException e) {
            log.error("Could not get 'from' address for message " + msgId + ". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return MessageUtil.getAddress(addresses, msgId);
    }

    public static final Optional<String> getFromEmail(MimeMessage msg) {
        Optional<Address> address = MessageUtil.getFrom(msg);
        return Optional.ofNullable(address.isPresent() ? MessageUtil.getEmail(address.get()) : null);
    }

    public static final Optional<Address> getTo(MimeMessage msg) {
        Address[] addresses;
        String msgId = MessageUtil.getMessageId((Message)msg);
        try {
            addresses = msg.getRecipients(Message.RecipientType.TO);
        }
        catch (MessagingException e) {
            log.error("Could not get 'to' address for message " + msgId + ". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return MessageUtil.getAddress(addresses, MessageUtil.getMessageId((Message)msg));
    }

    public static final Optional<String> getToEmail(MimeMessage msg) {
        Optional<Address> address = MessageUtil.getTo(msg);
        return Optional.ofNullable(address.isPresent() ? MessageUtil.getEmail(address.get()) : null);
    }

    public static final String getEmail(Address address) {
        if (address == null) {
            return null;
        }
        String email = address instanceof InternetAddress ? ((InternetAddress)address).getAddress() : address.toString();
        log.trace("Email for address {}: {}", (Object)address, (Object)email);
        return email;
    }

    private static final Optional<Address> getAddress(Address[] addresses, String msgId) {
        if (addresses == null || addresses.length == 0 || addresses[0] == null) {
            log.warn("No addresses found in message {}.", (Object)msgId);
            return Optional.empty();
        }
        if (addresses.length > 1) {
            log.warn("Multiple email addresses found in message {}, when only one was expected. Using first address. Found addresses: {}", (Object)msgId, (Object)Arrays.toString(addresses));
        }
        return Optional.ofNullable(addresses[0]);
    }

    public static final Optional<String> getReceivedEmail(Message msg) {
        Enumeration receivedHeaders;
        String msgId = MessageUtil.getMessageId(msg);
        try {
            receivedHeaders = msg.getMatchingHeaders(new String[]{"Received"});
        }
        catch (MessagingException e) {
            log.error("Could not get received headers for message " + msgId + ". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        String match = null;
        while (receivedHeaders.hasMoreElements()) {
            String value = ((Header)receivedHeaders.nextElement()).getValue();
            log.trace("Received header: {}", (Object)value);
            Matcher matcher = RECEIVED_EMAIL_PATTERN.matcher(value);
            if (!matcher.find()) continue;
            match = matcher.group(1);
        }
        return Optional.ofNullable(match);
    }

    public static final String getMessageId(Message msg) {
        if (msg == null) {
            return null;
        }
        try {
            Object[] idHeaders = msg.getHeader("Message-ID");
            if (idHeaders != null) {
                return idHeaders.length == 1 ? idHeaders[0] : Arrays.toString(idHeaders);
            }
        }
        catch (MessagingException e) {
            log.error("Could not get message ID for message with serial number " + msg.getMessageNumber() + ". Error message: " + e.getMessage(), (Throwable)e);
        }
        return "!" + msg.getMessageNumber() + "!";
    }

    public static final void movePart(Part from, Part to) throws IOException, MessagingException {
        MessageUtil.removeMatchingHeaders(to, Constants.STRUCTURAL_MIME_HEADERS);
        ContentType contentType = new ContentType(from.getContentType());
        if (contentType.match("multipart/*")) {
            to.setContent((Multipart)from.getContent());
        } else if (contentType.match("text/*")) {
            to.setContent(from.getContent(), from.getContentType());
        } else {
            try (InputStream is = from.getInputStream();){
                to.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(is, from.getContentType())));
            }
        }
        MessageUtil.copyMatchingHeaders(from, to, Constants.STRUCTURAL_MIME_HEADERS);
    }

    public static final String getHeader(Message msg, String headerName) throws MessagingException {
        String value;
        String[] headers = msg.getHeader(headerName);
        String string = value = headers != null ? headers[0] : null;
        if (value != null) {
            value = MimeUtility.unfold((String)value);
            try {
                value = MimeUtility.decodeText((String)value);
            }
            catch (UnsupportedEncodingException e) {
                String errMsg = "Could not decode \"" + value + "\". Error message: " + e.getMessage();
                throw new MessagingException(errMsg, (Exception)e);
            }
        }
        return value;
    }

    public static final void setHeader(Message msg, String headerName, String headerValue) throws MessagingException {
        try {
            String encodedHeaderValue = MimeUtility.fold((int)headerName.length(), (String)MimeUtility.encodeText((String)headerValue, (String)"UTF-8", null));
            msg.setHeader(headerName, encodedHeaderValue);
        }
        catch (UnsupportedEncodingException e) {
            String errMsg = "Could not encode \"" + headerValue + "\". Error message: " + e.getMessage();
            throw new MessagingException(errMsg, (Exception)e);
        }
    }

    public static final void setHeader(Message msg, String headerName, String valuePattern, Object ... values) throws MessagingException {
        String headerValue = MessageFormat.format(valuePattern, values);
        MessageUtil.setHeader(msg, headerName, headerValue);
    }

    public static final void copyAllHeaders(Part from, Part to) throws MessagingException {
        MessageUtil.copyHeaders(to, from.getAllHeaders());
    }

    public static final void copyMatchingHeaders(Part from, Part to, String ... headers) throws MessagingException {
        MessageUtil.copyHeaders(to, from.getMatchingHeaders(headers));
    }

    public static final void copyNonMatchingHeaders(Part from, Part to, String ... headers) throws MessagingException {
        MessageUtil.copyHeaders(to, from.getNonMatchingHeaders(headers));
    }

    private static final void copyHeaders(Part to, Enumeration<Header> headers) throws MessagingException {
        while (headers.hasMoreElements()) {
            Header header = headers.nextElement();
            log.trace("Copied header: {}: {}", (Object)header.getName(), (Object)header.getValue());
            to.setHeader(header.getName(), header.getValue());
        }
    }

    public static final void removeMatchingHeaders(Part part, String ... headers) throws MessagingException {
        MessageUtil.removeHeaders(part, part.getMatchingHeaders(headers));
    }

    public static final void removeNonMatchingHeaders(Part part, String ... headers) throws MessagingException {
        MessageUtil.removeHeaders(part, part.getNonMatchingHeaders(headers));
    }

    private static final void removeHeaders(Part part, Enumeration<Header> headers) throws MessagingException {
        while (headers.hasMoreElements()) {
            Header header = headers.nextElement();
            log.trace("Removed header: {}", (Object)header.getName());
            part.removeHeader(header.getName());
        }
    }
}

