/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification.pgp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.function.Consumer;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.pgp.PgpKeyBoxLoader;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpKeyBoxVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(PgpKeyBoxVerification.class);
    private final String location;
    private String email;

    public PgpKeyBoxVerification(String location, ISnotifyI18n i18n) {
        super(i18n);
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        this.location = location;
        this.getBuilder().title("net.savignano.snotify.key-management.verification.pgp.keybox.title", new Object[0]);
        this.setReportKey(false);
    }

    @Override
    protected void doVerify() throws Exception {
        this.canReadLocation();
    }

    private void canReadLocation() {
        Exception e = null;
        boolean canRead = false;
        try {
            canRead = new File(this.location).canRead();
            log.debug("Can access key box at location {}: {}", (Object)this.location, (Object)canRead);
        }
        catch (Exception e1) {
            e = e1;
            log.debug("Cannot access key box location: " + this.location, (Throwable)e);
        }
        if (canRead) {
            this.getBuilder().success();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.canRead.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.canRead.success.message", this.location);
            this.build();
            this.loadKeyStore();
        } else if (e != null) {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.canRead.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.canRead.exception.message", this.location, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        } else {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.canRead.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.canRead.failure.message", this.location);
            this.build();
        }
    }

    private void loadKeyStore() {
        Exception e = null;
        KeyBox keyBox = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.location));){
            keyBox = PgpUtil.loadKeyBox(is);
            log.debug("Could load key box from location: {}", (Object)this.location);
        }
        catch (Exception e1) {
            e = e1;
            log.debug("Could not load key box from location: " + this.location, (Throwable)e);
        }
        if (e == null) {
            if (keyBox == null || keyBox.getKeyBlobs().size() == 0) {
                this.getBuilder().error();
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.loadKeyStore.empty.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.loadKeyStore.empty.message", new Object[0]);
                this.build();
            } else {
                this.getBuilder().success();
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.loadKeyStore.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.loadKeyStore.success.message", keyBox.getKeyBlobs().size());
                this.build();
                this.verifyLoader(keyBox);
            }
        } else {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.loadKeyStore.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.loadKeyStore.exception.message", e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        }
    }

    private void verifyLoader(KeyBox keyBox) {
        Consumer<InfoData> consumer = this::handleInfoData;
        PgpKeyBoxLoader loader = new PgpKeyBoxLoader(keyBox);
        loader.getInfoDataManager().register(consumer);
        loader.loadKey(this.getEmail());
        loader.getInfoDataManager().unregister(consumer);
    }

    private void handleInfoData(InfoData data) {
        switch (data.infoType) {
            case 102: {
                this.handleError((Exception)data.additionalData[0]);
                break;
            }
            case 100: {
                this.verifyKey((ICryptographyKey)data.additionalData[0]);
                break;
            }
            case 200: {
                break;
            }
            case 201: {
                this.emailNotPresent();
                break;
            }
            case 202: {
                this.emailFound((String)data.additionalData[0]);
                break;
            }
            case 203: {
                this.emailNotFound((String)data.additionalData[0]);
                break;
            }
            default: {
                log.debug("Unhandled info data of type: {}", (Object)data.infoType);
            }
        }
    }

    private void emailNotPresent() {
        this.setReportError(false);
        this.getBuilder().info();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.checkEmail.noEmail.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.checkEmail.noEmail.message", new Object[0]);
        this.build();
    }

    private void emailFound(String email) {
        this.setReportKey(true);
        this.getBuilder().success();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.checkEmail.success.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.checkEmail.success.message", email);
        this.build();
    }

    private void emailNotFound(String email) {
        this.getBuilder().warning();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.checkEmail.failure.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.checkEmail.failure.message", email);
        this.build();
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }
}

