/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.common;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.opensymphony.module.propertyset.DuplicatePropertyKeyException;
import com.opensymphony.module.propertyset.PropertyException;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ASnotifyAppProperties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@JiraComponent
public class SnotifyAppProperties
extends ASnotifyAppProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifyAppProperties.class);
    @ComponentImport
    private ApplicationProperties props;

    @Autowired
    public SnotifyAppProperties(ApplicationProperties props) {
        this.props = props;
    }

    @Override
    protected String get(String key) throws Exception {
        return this.getProps().getString(key);
    }

    @Override
    protected void set(String key, String value) throws Exception {
        this.getProps().setString(key, value);
    }

    @Override
    protected void remove(String key) throws Exception {
        this.getProps().setString(key, null);
    }

    @Override
    public boolean hasKey(EProperty prop) {
        if (prop == null) {
            log.error("Given property was null.", (Throwable)new NullPointerException());
            return false;
        }
        return this.getString(prop.getKey()) != null || this.getUnlimitedString(prop.getKey()) != null;
    }

    @Override
    protected String getUnlimitedString(String key) {
        String value;
        try {
            value = this.getProps().getText(key);
        }
        catch (PropertyException e) {
            log.error("Property exception loading application property " + key + ".", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            log.trace("App property \"{}\" is considered null.", (Object)key);
            return null;
        }
        log.trace("App property \"{}\" is: {}", (Object)key, (Object)value);
        return value;
    }

    @Override
    protected void setUnlimitedString(String key, String value) {
        try {
            try {
                log.trace("Setting app property \"{}\" to: {}", (Object)key, (Object)value);
                this.getProps().setText(key, value);
            }
            catch (DuplicatePropertyKeyException e) {
                log.debug("Exception setting application property " + key + ".", (Throwable)e);
                this.getProps().setText(key, null);
                this.getProps().setText(key, value);
            }
            if (log.isTraceEnabled()) {
                String newValue = this.getProps().getText(key);
                if (value == null ? newValue != null : !value.equals(newValue)) {
                    log.error("Setting of app property \"{}\" failed. Expected value: \"{}\". Actual value: \"{}\"", new Object[]{key, value, newValue});
                }
            }
        }
        catch (PropertyException e) {
            log.error("Property exception setting application property " + key + ".", (Throwable)e);
        }
    }

    private ApplicationProperties getProps() {
        if (this.props == null) {
            log.trace("Injection of ApplicationProperties failed. Loading manually.");
            this.props = ComponentAccessor.getApplicationProperties();
        }
        return this.props;
    }
}

