/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.common;

import com.atlassian.jira.util.I18nHelper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;

public class SnotifyI18n
implements ISnotifyI18n {
    private final I18nHelper i18n;

    public SnotifyI18n(I18nHelper i18n) {
        this.i18n = i18n;
        if (i18n == null) {
            throw new IllegalArgumentException("I18n must not be null.");
        }
    }

    @Override
    public String getText(String key) {
        return this.i18n.getText(key);
    }

    @Override
    public String getText(String key, Object value) {
        return this.i18n.getText(key, value);
    }

    @Override
    public String getText(String key, Object value1, Object value2) {
        return this.i18n.getText(key, (Object)new Object[]{value1, value2});
    }

    @Override
    public String getText(String key, Object ... values) {
        return this.i18n.getText(key, (Object)values);
    }

    @Override
    public String formatDate(LocalDate date, FormatStyle style) {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(style).withLocale(this.i18n.getLocale());
        return formatter.format(date);
    }

    @Override
    public String formatDateTime(LocalDateTime dateTime, FormatStyle style) {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(style).withLocale(this.i18n.getLocale());
        return formatter.format(dateTime);
    }

    @Override
    public String formatTime(LocalTime time, FormatStyle style) {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedTime(style).withLocale(this.i18n.getLocale());
        return formatter.format(time);
    }
}

