/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.ManagedCache;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.concurrent.TimeUnit;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.gui.APluginListener;
import net.savignano.snotify.atlassian.gui.AtlassianMailerVersion;
import net.savignano.snotify.jira.common.JiraConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class JiraPluginListener
extends APluginListener {
    private static final Logger log = LoggerFactory.getLogger(JiraPluginListener.class);
    @ComponentImport
    private final CacheManager cacheManager;

    @Autowired
    public JiraPluginListener(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    protected void setMailerVersion() {
        SMTPMailServer server = MailFactory.getServerManager().getDefaultSMTPMailServer();
        if (server == null) {
            this.getAppProps().setString(EProperty.MAILER_VERSION, null);
            log.warn("Cannot check if correct mailer library for S/Notify is installed. Please configure an outgoing SMTP mail server, so S/Notify can automatically check if the GUI plugin and Mailer library are compatible with each other.");
            return;
        }
        AtlassianMailerVersion mailerVersion = new AtlassianMailerVersion(server, this.getAppProps());
        mailerVersion.setAtlassianUrl(ComponentAccessor.getApplicationProperties().getString("jira.baseurl"));
        mailerVersion.setProductInfo(JiraConstants.PRODUCT_INFORMATION);
        mailerVersion.getVersion();
    }

    @Override
    protected void createCache() {
        CacheSettings settings = new CacheSettingsBuilder().expireAfterAccess(15L, TimeUnit.MINUTES).remote().replicateAsynchronously().replicateViaCopy().statisticsEnabled().unflushable().build();
        log.debug("Creating cache with name {} with the following settings: {}", (Object)"net.savignano.snotify.jira.cache.pgp.incomingMail", (Object)settings);
        this.cacheManager.getCache("net.savignano.snotify.jira.cache.pgp.incomingMail", null, settings);
        log.debug("Creating cache with name {} with the following settings: {}", (Object)"net.savignano.snotify.jira.cache.smime.incomingMail", (Object)settings);
        this.cacheManager.getCache("net.savignano.snotify.jira.cache.smime.incomingMail", null, settings);
    }

    @Override
    protected void destroyCache() {
        ManagedCache pgpCache;
        ManagedCache smimeCache = this.cacheManager.getManagedCache("net.savignano.snotify.jira.cache.pgp.incomingMail");
        if (smimeCache != null) {
            if (log.isDebugEnabled()) {
                log.debug("Clearing cache with name {}. Cache statistics: {}", (Object)"net.savignano.snotify.jira.cache.pgp.incomingMail", (Object)smimeCache.getStatistics());
            }
            smimeCache.clear();
        }
        if ((pgpCache = this.cacheManager.getManagedCache("net.savignano.snotify.jira.cache.smime.incomingMail")) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Clearing cache with name {}. Cache statistics: {}", (Object)"net.savignano.snotify.jira.cache.smime.incomingMail", (Object)pgpCache.getStatistics());
            }
            pgpCache.clear();
        }
    }
}

