/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.webpanel;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.gui.key.info.IKeyValueStyle;
import net.savignano.snotify.atlassian.gui.key.info.PgpPublicKeyInfoBuilder;
import net.savignano.snotify.atlassian.gui.key.info.SmimeCertInfoBuilder;
import net.savignano.snotify.jira.common.JiraUser;
import net.savignano.snotify.jira.common.SnotifyI18n;
import net.savignano.snotify.jira.gui.key.info.HtmlKeyValueStyle;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailSettingsContextProvider
implements ContextProvider {
    private static final String PROFILE_USER_KEY = "profileUser";
    private static final String CURRENT_USER_KEY = "currentUser";
    private static final String EMAIL_CERT_CONTEXT = "cert";
    private static final String EMAIL_CERT_INFO_CONTEXT = "cert_info_html";
    private static final String EMAIL_KEY_CONTEXT = "key";
    private static final String EMAIL_KEY_INFO_CONTEXT = "key_info_html";
    private static final String EDIT_ALLOWED_CONTEXT = "edit_allowed";
    private static final String USER_ERROR_CONTEXT = "user_error";
    private static final String MULTIPLE_USER_WARNING_CONTEXT = "multiple_users";
    private static final Logger log = LoggerFactory.getLogger(EmailSettingsContextProvider.class);
    private ISnotifyAppProperties appProps;
    private ISnotifyUserProperties userProps;

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        JiraUser currentUser = this.getCurrentUser(context);
        JiraUser profileUser = this.getProfileUser(context);
        HashMap<String, Object> contextMap = new HashMap<String, Object>(context);
        if (currentUser == null || profileUser == null) {
            this.fillContextUserError(contextMap);
        } else {
            this.fillContext(contextMap, profileUser, currentUser);
        }
        return contextMap;
    }

    protected JiraUser getProfileUser(Map<String, Object> context) {
        if (context.get(PROFILE_USER_KEY) != null) {
            return new JiraUser((ApplicationUser)context.get(PROFILE_USER_KEY));
        }
        log.error("No profile user was found in context map.");
        return null;
    }

    protected JiraUser getCurrentUser(Map<String, Object> context) {
        if (context.get(CURRENT_USER_KEY) != null) {
            return new JiraUser((ApplicationUser)context.get(CURRENT_USER_KEY));
        }
        log.error("No current user was found in context map.");
        return null;
    }

    private void fillContextUserError(Map<String, Object> context) {
        context.put(USER_ERROR_CONTEXT, true);
    }

    private void fillContext(Map<String, Object> context, JiraUser profileUser, JiraUser currentUser) {
        SnotifyI18n i18n = new SnotifyI18n(ComponentAccessor.getI18nHelperFactory().getInstance(currentUser.getActualUser()));
        EEncryptionTypePriority typePriority = this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
        if (typePriority != EEncryptionTypePriority.PGP_ONLY) {
            context.putAll(this.getSmimeCertContext(profileUser, i18n));
        }
        if (typePriority != EEncryptionTypePriority.SMIME_ONLY) {
            context.putAll(this.getPgpCertContext(profileUser, i18n));
        }
        boolean editAllowed = this.isEditAllowed(profileUser, currentUser, typePriority);
        context.put(EDIT_ALLOWED_CONTEXT, editAllowed);
        context.put(MULTIPLE_USER_WARNING_CONTEXT, editAllowed && JiraUser.lookupUsers(profileUser.getEmail()).size() > 1);
    }

    private boolean isEditAllowed(JiraUser profileUser, JiraUser currentUser, EEncryptionTypePriority typePriority) {
        boolean allowed = currentUser.equals(profileUser);
        if (allowed && !this.getAppProps().getBoolean(EProperty.LITE_MODE)) {
            if (typePriority == EEncryptionTypePriority.PGP_ONLY) {
                allowed = this.getAppProps().getBoolean(EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE);
            } else if (typePriority == EEncryptionTypePriority.SMIME_ONLY) {
                allowed = this.getAppProps().getBoolean(EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE);
            } else {
                boolean smime = this.getAppProps().getBoolean(EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE);
                boolean pgp = this.getAppProps().getBoolean(EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE);
                allowed = smime || pgp;
            }
        }
        return allowed;
    }

    private Map<String, Object> getSmimeCertContext(JiraUser user, ISnotifyI18n i18n) {
        String displayName = user.getDisplayName();
        String certInfo = null;
        Object cert = this.getAppProps().getBoolean(EProperty.LITE_MODE) && this.getUserProps().getEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.class, user) != EKeySource.USER ? null : this.getUserProps().getBytes(EProperty.EMAIL_SMIME_CERT, user);
        if (cert == null) {
            certInfo = i18n.getText("email-security.settings.smime.notfound");
            log.debug("No certificate specified for user: {}", (Object)displayName);
        } else {
            try {
                certInfo = this.buildCertInfo((byte[])cert, i18n, user);
                log.debug("Certificate information for user {}: {}", (Object)displayName, (Object)certInfo);
            }
            catch (CertificateException e) {
                log.warn("Could not load public certificate for user: " + displayName, (Throwable)e);
                certInfo = i18n.getText("email-security.settings.smime.error", (Object)e.getLocalizedMessage());
            }
        }
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put(EMAIL_CERT_CONTEXT, cert);
        contextMap.put(EMAIL_CERT_INFO_CONTEXT, certInfo);
        return contextMap;
    }

    private Map<String, Object> getPgpCertContext(JiraUser user, ISnotifyI18n i18n) {
        Long keyId;
        byte[] key;
        String displayName = user.getDisplayName();
        String keyInfo = null;
        if (this.getAppProps().getBoolean(EProperty.LITE_MODE) && this.getUserProps().getEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.class, user) != EKeySource.USER) {
            key = null;
            keyId = null;
        } else {
            key = this.getUserProps().getBytes(EProperty.EMAIL_PGP_KEY, user);
            keyId = this.getUserProps().getLong(EProperty.EMAIL_PGP_KEY_ID, user);
        }
        if (keyId == null || key == null) {
            keyInfo = i18n.getText("email-security.settings.pgp.notfound");
            log.debug("No public key specified for user: {}", (Object)displayName);
        } else {
            try {
                keyInfo = this.buildKeyInfo(key, keyId, i18n, user);
                log.debug("Key information for user {}: {}", (Object)displayName, (Object)keyInfo);
            }
            catch (IOException | PGPException e) {
                log.warn("Could not load PGP key for user: " + displayName, (Throwable)e);
                keyInfo = i18n.getText("email-security.settings.pgp.error", (Object)e.getLocalizedMessage());
            }
        }
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put(EMAIL_KEY_CONTEXT, key);
        contextMap.put(EMAIL_KEY_INFO_CONTEXT, keyInfo);
        return contextMap;
    }

    private String buildCertInfo(byte[] cert, ISnotifyI18n i18n, JiraUser user) throws CertificateException {
        SmimeCertInfoBuilder builder = new SmimeCertInfoBuilder(cert, i18n);
        builder.setUser(user);
        builder.setUserProps(this.getUserProps());
        return builder.build(this.getKeyValueStyle());
    }

    private String buildKeyInfo(byte[] key, long keyId, ISnotifyI18n i18n, JiraUser user) throws IOException, PGPException {
        PgpPublicKeyInfoBuilder builder = new PgpPublicKeyInfoBuilder(key, keyId, i18n);
        builder.setUser(user);
        builder.setUserProps(this.getUserProps());
        return builder.build(this.getKeyValueStyle());
    }

    protected IKeyValueStyle getKeyValueStyle() {
        return new HtmlKeyValueStyle();
    }

    public ISnotifyAppProperties getAppProps() {
        return this.appProps;
    }

    @Autowired
    public void setAppProps(ISnotifyAppProperties appProps) {
        this.appProps = appProps;
    }

    public ISnotifyUserProperties getUserProps() {
        return this.userProps;
    }

    @Autowired
    public void setUserProps(ISnotifyUserProperties userProps) {
        this.userProps = userProps;
    }
}

