/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.gui.webwork;

import com.atlassian.jira.security.request.RequestMethod;
import com.atlassian.jira.security.request.SupportedMethods;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyProjectProperties;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusBuilder;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusDisplay;
import net.savignano.snotify.jira.gui.webwork.SnotifyAdminSettingsAction;
import org.springframework.beans.factory.annotation.Autowired;

public class SnotifyProjectSettingsAction
extends SnotifyAdminSettingsAction {
    private static final long serialVersionUID = -4080774429537935438L;
    private static final String ENCRYPTION_ENABLED_PARAM = "encryptionEnabled";
    private ISnotifyProjectProperties projectProps;
    private String errorMessage;

    @SupportedMethods(value={RequestMethod.GET})
    public String doInput() {
        return "input";
    }

    @RequiresXsrfCheck
    @SupportedMethods(value={RequestMethod.POST})
    public String doSubmit() {
        boolean encryptionEnabled = Boolean.parseBoolean(this.getHttpRequest().getParameter(ENCRYPTION_ENABLED_PARAM));
        String projectKey = this.getProjectKey();
        this.getProjectProps().setBoolean(EProperty.PROJECT_ENABLE_ENCRYPTION, encryptionEnabled, projectKey);
        boolean actualEncryptionEnabled = this.getProjectProps().getBoolean(EProperty.PROJECT_ENABLE_ENCRYPTION, true, projectKey);
        if (encryptionEnabled != actualEncryptionEnabled) {
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getSnotifyI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.projectLeadErrorTitle", new Object[0]);
            builder.message("snotify-tweak-webwork.input.projectLeadErrorMessage", new Object[0]);
            this.errorMessage = VerificationStatusDisplay.getHtml(builder.build());
        } else {
            this.setShowUpdated(true);
        }
        return "input";
    }

    public boolean isEncryptionEnabled() {
        boolean defaultEncryption = this.getAppProps().getBoolean(EProperty.DEFAULT_PROJECT_ENCRYPTION_STATE);
        boolean checked = this.getProjectProps().getBoolean(EProperty.PROJECT_ENABLE_ENCRYPTION, defaultEncryption, this.getSelectedProject().getKey());
        return checked;
    }

    public boolean isProjectSpecificEncryptionAllowed() {
        return this.getAppProps().getBoolean(EProperty.ENABLE_PROJECT_SPECIFIC_ENCRYPTION);
    }

    @HtmlSafe
    public String getErrorMessage() {
        return this.errorMessage == null ? "" : this.errorMessage;
    }

    public String getProjectKey() {
        return this.getSelectedProject().getKey();
    }

    public ISnotifyProjectProperties getProjectProps() {
        return this.projectProps;
    }

    @Autowired
    public void setProjectProps(ISnotifyProjectProperties projectProps) {
        this.projectProps = projectProps;
    }
}

