/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmp;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class KemCiphertextInfo
extends ASN1Object {
    private final AlgorithmIdentifier kem;
    private final ASN1OctetString ct;

    private KemCiphertextInfo(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("sequence size should 2");
        }
        this.kem = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        this.ct = ASN1OctetString.getInstance(seq.getObjectAt(1));
    }

    public KemCiphertextInfo(AlgorithmIdentifier kem, ASN1OctetString ct) {
        this.kem = kem;
        this.ct = ct;
    }

    public static KemCiphertextInfo getInstance(Object o) {
        if (o instanceof KemCiphertextInfo) {
            return (KemCiphertextInfo)o;
        }
        if (o != null) {
            return new KemCiphertextInfo(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public AlgorithmIdentifier getKem() {
        return this.kem;
    }

    public ASN1OctetString getCt() {
        return this.ct;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add(this.kem);
        v.add(this.ct);
        return new DERSequence(v);
    }
}

