/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg.sig;

import net.savignano.thirdparty.org.bouncycastle.bcpg.sig.PreferredAlgorithms;

public class PreferredAEADCiphersuites
extends PreferredAlgorithms {
    private final Combination[] algorithms;
    private static final Combination AES_128_OCB = new Combination(7, 2);

    public PreferredAEADCiphersuites(boolean critical, boolean isLongLength, byte[] data) {
        super(39, critical, isLongLength, PreferredAEADCiphersuites.requireEven(data));
        this.algorithms = PreferredAEADCiphersuites.parseCombinations(data);
    }

    public PreferredAEADCiphersuites(boolean critical, Combination[] combinations) {
        this(critical, false, PreferredAEADCiphersuites.encodeCombinations(combinations));
    }

    private static Combination[] parseCombinations(byte[] data) {
        Combination[] algorithms = new Combination[data.length / 2];
        for (int i = 0; i < algorithms.length; ++i) {
            algorithms[i] = new Combination(data[i * 2], data[i * 2 + 1]);
        }
        return algorithms;
    }

    private static byte[] encodeCombinations(Combination[] combinations) {
        byte[] encoding = new byte[combinations.length * 2];
        for (int i = 0; i < combinations.length; ++i) {
            Combination combination = combinations[i];
            encoding[i * 2] = (byte)(combination.getSymmetricAlgorithm() & 0xFF);
            encoding[i * 2 + 1] = (byte)(combination.getAeadAlgorithm() & 0xFF);
        }
        return encoding;
    }

    public boolean isSupported(Combination combination) {
        return PreferredAEADCiphersuites.contains(combination, this.getAlgorithms());
    }

    private static boolean contains(Combination combination, Combination[] combinations) {
        for (int i = 0; i != combinations.length; ++i) {
            Combination supported = combinations[i];
            if (!supported.equals(combination)) continue;
            return true;
        }
        return false;
    }

    public Combination[] getRawAlgorithms() {
        Combination[] copy = new Combination[this.algorithms.length];
        System.arraycopy(this.algorithms, 0, copy, 0, this.algorithms.length);
        return copy;
    }

    public Combination[] getAlgorithms() {
        if (!PreferredAEADCiphersuites.contains(AES_128_OCB, this.algorithms)) {
            Combination[] withImplicitOptionAppended = new Combination[this.algorithms.length + 1];
            System.arraycopy(this.algorithms, 0, withImplicitOptionAppended, 0, this.algorithms.length);
            withImplicitOptionAppended[this.algorithms.length] = AES_128_OCB;
            return withImplicitOptionAppended;
        }
        return this.getRawAlgorithms();
    }

    private static byte[] requireEven(byte[] encodedCombinations) {
        if (encodedCombinations.length % 2 != 0) {
            throw new IllegalArgumentException("Even number of bytes expected.");
        }
        return encodedCombinations;
    }

    public static class Combination {
        private final int symmetricAlgorithm;
        private final int aeadAlgorithm;

        public Combination(int symmetricAlgorithmTag, int aeadAlgorithmTag) {
            this.symmetricAlgorithm = symmetricAlgorithmTag;
            this.aeadAlgorithm = aeadAlgorithmTag;
        }

        public int getSymmetricAlgorithm() {
            return this.symmetricAlgorithm;
        }

        public int getAeadAlgorithm() {
            return this.aeadAlgorithm;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof Combination)) {
                return false;
            }
            Combination other = (Combination)o;
            return this.getSymmetricAlgorithm() == other.getSymmetricAlgorithm() && this.getAeadAlgorithm() == other.getAeadAlgorithm();
        }

        public int hashCode() {
            return 13 * this.getSymmetricAlgorithm() + 17 * this.getAeadAlgorithm();
        }
    }
}

