/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms.jcajce;

import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.KEMKeyWrapper;
import net.savignano.thirdparty.org.bouncycastle.cms.KEMRecipientInfoGenerator;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JceCMSKEMKeyWrapper;

public class JceKEMRecipientInfoGenerator
extends KEMRecipientInfoGenerator {
    public JceKEMRecipientInfoGenerator(X509Certificate recipientCert, ASN1ObjectIdentifier symWrapAlgorithm) throws CertificateEncodingException {
        super(new IssuerAndSerialNumber(new JcaX509CertificateHolder(recipientCert).toASN1Structure()), (KEMKeyWrapper)new JceCMSKEMKeyWrapper(recipientCert.getPublicKey(), symWrapAlgorithm));
    }

    public JceKEMRecipientInfoGenerator(byte[] subjectKeyIdentifier, PublicKey publicKey, ASN1ObjectIdentifier symWrapAlgorithm) {
        super(subjectKeyIdentifier, (KEMKeyWrapper)new JceCMSKEMKeyWrapper(publicKey, symWrapAlgorithm));
    }

    public JceKEMRecipientInfoGenerator setProvider(String providerName) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setProvider(providerName);
        return this;
    }

    public JceKEMRecipientInfoGenerator setProvider(Provider provider) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setProvider(provider);
        return this;
    }

    public JceKEMRecipientInfoGenerator setSecureRandom(SecureRandom random) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setSecureRandom(random);
        return this;
    }

    public JceKEMRecipientInfoGenerator setKDF(AlgorithmIdentifier kdfAlgorithm) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setKDF(kdfAlgorithm);
        return this;
    }

    public JceKEMRecipientInfoGenerator setAlgorithmMapping(ASN1ObjectIdentifier algorithm, String algorithmName) {
        ((JceCMSKEMKeyWrapper)this.wrapper).setAlgorithmMapping(algorithm, algorithmName);
        return this;
    }
}

