/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.dvcs;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.asn1.dvcs.CertEtcToken;
import net.savignano.thirdparty.org.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import net.savignano.thirdparty.org.bouncycastle.asn1.dvcs.DVCSTime;
import net.savignano.thirdparty.org.bouncycastle.asn1.dvcs.Data;
import net.savignano.thirdparty.org.bouncycastle.asn1.dvcs.ServiceType;
import net.savignano.thirdparty.org.bouncycastle.asn1.dvcs.TargetEtcChain;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.Extension;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.dvcs.DVCSException;
import net.savignano.thirdparty.org.bouncycastle.dvcs.DVCSRequest;
import net.savignano.thirdparty.org.bouncycastle.dvcs.DVCSRequestBuilder;
import net.savignano.thirdparty.org.bouncycastle.dvcs.TargetChain;

public class VPKCRequestBuilder
extends DVCSRequestBuilder {
    private List chains = new ArrayList();

    public VPKCRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VPKC));
    }

    public void addTargetChain(X509CertificateHolder cert) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(0, cert.toASN1Structure())));
    }

    public void addTargetChain(Extension extension) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(extension)));
    }

    public void addTargetChain(TargetChain targetChain) {
        this.chains.add(targetChain.toASN1Structure());
    }

    public void setRequestTime(Date requestTime) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(requestTime));
    }

    public DVCSRequest build() throws DVCSException {
        Data data = new Data(this.chains.toArray(new TargetEtcChain[this.chains.size()]));
        return this.createDVCRequest(data);
    }
}

