/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoException;
import net.savignano.thirdparty.org.bouncycastle.crypto.Signer;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.ParametersWithRandom;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentSigner;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.SignerOutputStream;
import net.savignano.thirdparty.org.bouncycastle.util.io.TeeOutputStream;

public class BcPGPContentSignerBuilder
implements PGPContentSignerBuilder {
    private BcPGPDigestCalculatorProvider digestCalculatorProvider = new BcPGPDigestCalculatorProvider();
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private int hashAlgorithm;
    private SecureRandom random;
    private int keyAlgorithm;

    public BcPGPContentSignerBuilder(int keyAlgorithm, int hashAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
    }

    public BcPGPContentSignerBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    public PGPContentSigner build(final int signatureType, final PGPPrivateKey privateKey) throws PGPException {
        AsymmetricKeyParameter privKeyParam = this.keyConverter.getPrivateKey(privateKey);
        final PGPDigestCalculator digestCalculator = this.digestCalculatorProvider.get(this.hashAlgorithm);
        final Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm, privKeyParam);
        if (this.random != null) {
            signer.init(true, new ParametersWithRandom(privKeyParam, this.random));
        } else {
            signer.init(true, privKeyParam);
        }
        return new PGPContentSigner(){

            @Override
            public int getType() {
                return signatureType;
            }

            @Override
            public int getHashAlgorithm() {
                return BcPGPContentSignerBuilder.this.hashAlgorithm;
            }

            @Override
            public int getKeyAlgorithm() {
                return BcPGPContentSignerBuilder.this.keyAlgorithm;
            }

            @Override
            public long getKeyID() {
                return privateKey.getKeyID();
            }

            @Override
            public OutputStream getOutputStream() {
                return new TeeOutputStream(new SignerOutputStream(signer), digestCalculator.getOutputStream());
            }

            @Override
            public byte[] getSignature() {
                try {
                    return signer.generateSignature();
                }
                catch (CryptoException e) {
                    throw new IllegalStateException("unable to create signature");
                }
            }

            @Override
            public byte[] getDigest() {
                return digestCalculator.getDigest();
            }
        };
    }
}

