/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium;

import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecK;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium.PolyVecL;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

class Packing {
    Packing() {
    }

    static byte[] packPublicKey(PolyVecK t1, DilithiumEngine engine) {
        byte[] out = new byte[engine.getCryptoPublicKeyBytes() - 32];
        for (int i = 0; i < engine.getDilithiumK(); ++i) {
            System.arraycopy(t1.getVectorIndex(i).polyt1Pack(), 0, out, i * 320, 320);
        }
        return out;
    }

    static PolyVecK unpackPublicKey(PolyVecK t1, byte[] publicKey, DilithiumEngine engine) {
        for (int i = 0; i < engine.getDilithiumK(); ++i) {
            t1.getVectorIndex(i).polyt1Unpack(Arrays.copyOfRange(publicKey, i * 320, 32 + (i + 1) * 320));
        }
        return t1;
    }

    static byte[][] packSecretKey(byte[] rho, byte[] tr, byte[] key, PolyVecK t0, PolyVecL s1, PolyVecK s2, DilithiumEngine engine) {
        int i;
        byte[][] out = new byte[6][];
        out[0] = rho;
        out[1] = key;
        out[2] = tr;
        out[3] = new byte[engine.getDilithiumL() * engine.getDilithiumPolyEtaPackedBytes()];
        for (i = 0; i < engine.getDilithiumL(); ++i) {
            s1.getVectorIndex(i).polyEtaPack(out[3], i * engine.getDilithiumPolyEtaPackedBytes());
        }
        out[4] = new byte[engine.getDilithiumK() * engine.getDilithiumPolyEtaPackedBytes()];
        for (i = 0; i < engine.getDilithiumK(); ++i) {
            s2.getVectorIndex(i).polyEtaPack(out[4], i * engine.getDilithiumPolyEtaPackedBytes());
        }
        out[5] = new byte[engine.getDilithiumK() * 416];
        for (i = 0; i < engine.getDilithiumK(); ++i) {
            t0.getVectorIndex(i).polyt0Pack(out[5], i * 416);
        }
        return out;
    }

    static void unpackSecretKey(PolyVecK t0, PolyVecL s1, PolyVecK s2, byte[] t0Enc, byte[] s1Enc, byte[] s2Enc, DilithiumEngine engine) {
        int i;
        for (i = 0; i < engine.getDilithiumL(); ++i) {
            s1.getVectorIndex(i).polyEtaUnpack(s1Enc, i * engine.getDilithiumPolyEtaPackedBytes());
        }
        for (i = 0; i < engine.getDilithiumK(); ++i) {
            s2.getVectorIndex(i).polyEtaUnpack(s2Enc, i * engine.getDilithiumPolyEtaPackedBytes());
        }
        for (i = 0; i < engine.getDilithiumK(); ++i) {
            t0.getVectorIndex(i).polyt0Unpack(t0Enc, i * 416);
        }
    }

    static byte[] packSignature(byte[] c, PolyVecL z, PolyVecK h, DilithiumEngine engine) {
        int i;
        int end = 0;
        byte[] outBytes = new byte[engine.getCryptoBytes()];
        System.arraycopy(c, 0, outBytes, 0, engine.getDilithiumCTilde());
        end += engine.getDilithiumCTilde();
        for (i = 0; i < engine.getDilithiumL(); ++i) {
            System.arraycopy(z.getVectorIndex(i).zPack(), 0, outBytes, end + i * engine.getDilithiumPolyZPackedBytes(), engine.getDilithiumPolyZPackedBytes());
        }
        end += engine.getDilithiumL() * engine.getDilithiumPolyZPackedBytes();
        for (i = 0; i < engine.getDilithiumOmega() + engine.getDilithiumK(); ++i) {
            outBytes[end + i] = 0;
        }
        int k = 0;
        for (i = 0; i < engine.getDilithiumK(); ++i) {
            for (int j = 0; j < 256; ++j) {
                if (h.getVectorIndex(i).getCoeffIndex(j) == 0) continue;
                outBytes[end + k++] = (byte)j;
            }
            outBytes[end + engine.getDilithiumOmega() + i] = (byte)k;
        }
        return outBytes;
    }

    static boolean unpackSignature(PolyVecL z, PolyVecK h, byte[] sig, DilithiumEngine engine) {
        int j;
        int i;
        int end = engine.getDilithiumCTilde();
        for (i = 0; i < engine.getDilithiumL(); ++i) {
            z.getVectorIndex(i).zUnpack(Arrays.copyOfRange(sig, end + i * engine.getDilithiumPolyZPackedBytes(), end + (i + 1) * engine.getDilithiumPolyZPackedBytes()));
        }
        end += engine.getDilithiumL() * engine.getDilithiumPolyZPackedBytes();
        int k = 0;
        for (i = 0; i < engine.getDilithiumK(); ++i) {
            for (j = 0; j < 256; ++j) {
                h.getVectorIndex(i).setCoeffIndex(j, 0);
            }
            if ((sig[end + engine.getDilithiumOmega() + i] & 0xFF) < k || (sig[end + engine.getDilithiumOmega() + i] & 0xFF) > engine.getDilithiumOmega()) {
                return false;
            }
            for (j = k; j < (sig[end + engine.getDilithiumOmega() + i] & 0xFF); ++j) {
                if (j > k && (sig[end + j] & 0xFF) <= (sig[end + j - 1] & 0xFF)) {
                    return false;
                }
                h.getVectorIndex(i).setCoeffIndex(sig[end + j] & 0xFF, 1);
            }
            k = sig[end + engine.getDilithiumOmega() + i];
        }
        for (j = k; j < engine.getDilithiumOmega(); ++j) {
            if ((sig[end + j] & 0xFF) == 0) continue;
            return false;
        }
        return true;
    }
}

