/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.BDS;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import net.savignano.thirdparty.org.bouncycastle.util.Integers;

public class BDSStateMap
implements Serializable {
    private static final long serialVersionUID = -3464451825208522308L;
    private final Map<Integer, BDS> bdsState = new TreeMap<Integer, BDS>();
    private transient long maxIndex;

    BDSStateMap(long maxIndex) {
        this.maxIndex = maxIndex;
    }

    BDSStateMap(BDSStateMap stateMap, long maxIndex) {
        for (Integer key : stateMap.bdsState.keySet()) {
            this.bdsState.put(key, new BDS(stateMap.bdsState.get(key)));
        }
        this.maxIndex = maxIndex;
    }

    BDSStateMap(XMSSMTParameters params, long globalIndex, byte[] publicSeed, byte[] secretKeySeed) {
        this.maxIndex = (1L << params.getHeight()) - 1L;
        for (long index = 0L; index < globalIndex; ++index) {
            this.updateState(params, index, publicSeed, secretKeySeed);
        }
    }

    public long getMaxIndex() {
        return this.maxIndex;
    }

    void updateState(XMSSMTParameters params, long globalIndex, byte[] publicSeed, byte[] secretKeySeed) {
        XMSSParameters xmssParams = params.getXMSSParameters();
        int xmssHeight = xmssParams.getHeight();
        long indexTree = XMSSUtil.getTreeIndex(globalIndex, xmssHeight);
        int indexLeaf = XMSSUtil.getLeafIndex(globalIndex, xmssHeight);
        OTSHashAddress otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(indexTree)).withOTSAddress(indexLeaf).build();
        if (indexLeaf < (1 << xmssHeight) - 1) {
            if (this.get(0) == null || indexLeaf == 0) {
                this.put(0, new BDS(xmssParams, publicSeed, secretKeySeed, otsHashAddress));
            }
            this.update(0, publicSeed, secretKeySeed, otsHashAddress);
        }
        for (int layer = 1; layer < params.getLayers(); ++layer) {
            indexLeaf = XMSSUtil.getLeafIndex(indexTree, xmssHeight);
            indexTree = XMSSUtil.getTreeIndex(indexTree, xmssHeight);
            otsHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(layer)).withTreeAddress(indexTree)).withOTSAddress(indexLeaf).build();
            if (this.bdsState.get(layer) == null || XMSSUtil.isNewBDSInitNeeded(globalIndex, xmssHeight, layer)) {
                this.bdsState.put(layer, new BDS(xmssParams, publicSeed, secretKeySeed, otsHashAddress));
            }
            if (indexLeaf >= (1 << xmssHeight) - 1 || !XMSSUtil.isNewAuthenticationPathNeeded(globalIndex, xmssHeight, layer)) continue;
            this.update(layer, publicSeed, secretKeySeed, otsHashAddress);
        }
    }

    public boolean isEmpty() {
        return this.bdsState.isEmpty();
    }

    BDS get(int index) {
        return this.bdsState.get(Integers.valueOf(index));
    }

    BDS update(int index, byte[] publicSeed, byte[] secretKeySeed, OTSHashAddress otsHashAddress) {
        return this.bdsState.put(Integers.valueOf(index), this.bdsState.get(Integers.valueOf(index)).getNextState(publicSeed, secretKeySeed, otsHashAddress));
    }

    void put(int index, BDS bds) {
        this.bdsState.put(Integers.valueOf(index), bds);
    }

    public BDSStateMap withWOTSDigest(ASN1ObjectIdentifier digestName) {
        BDSStateMap newStateMap = new BDSStateMap(this.maxIndex);
        for (Integer key : this.bdsState.keySet()) {
            newStateMap.bdsState.put(key, this.bdsState.get(key).withWOTSDigest(digestName));
        }
        return newStateMap;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.maxIndex = in.available() != 0 ? in.readLong() : 0L;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeLong(this.maxIndex);
    }
}

