// Displays correct tab.
function displayTab(t) {
	if(t == 'smime'){
		document.getElementById("tabs-menu-smime").classList.add('active-tab');
		document.getElementById("tabs-menu-pgp").classList.remove('active-tab');
		document.getElementById("tabs-smime").classList.add('active-pane');
		document.getElementById("tabs-pgp").classList.remove('active-pane');
		document.getElementById("tabs-smime").style.display='inline';
		document.getElementById("tabs-pgp").style.display='none';
	} else if(t == 'pgp') {
		document.getElementById("tabs-menu-smime").classList.remove('active-tab');
		document.getElementById("tabs-menu-pgp").classList.add('active-tab');
		document.getElementById("tabs-smime").classList.remove('active-pane');
		document.getElementById("tabs-pgp").classList.add('active-pane');
		document.getElementById("tabs-smime").style.display='none';
		document.getElementById("tabs-pgp").style.display='inline';
	}
}

// Stores which button is spinning.
var snotifyButton = null;

// Starts spinning on button, unless already spinning.
function startSpinning(b) {
	if (snotifyButton == null) {
		snotifyButton = b;
		snotifyButton.setAttribute('aria-disabled', 'true');
		snotifyButton.busy();
		return true;
	} else {
		return false;
	}
}

// Stops spinning.
function stopSpinning() {
	if (snotifyButton != null) {
		snotifyButton.setAttribute('aria-disabled', 'false');
		snotifyButton.idle();
		snotifyButton = null;
	}
}

// Empty error message
function resetMessage(){
    document.getElementById("jsd-upload-message-context").innerHTML = "";
} 

AJS.toInit(function () {

	// Show editing dialog.
    AJS.$('body').on('click', '#net\\.savignano\\.s-notify\\.jira\\.gui\\:jsd_portal_edit_pgp_smime_item', function (e) {
        e.preventDefault();

        AJS.dialog2('#pgp_smime_edit_view').show();
    });

	// Uploading S/MIME cert
    AJS.$('body').on('submit', '#smime_form_dialog', function (e) {
        e.preventDefault();

        resetMessage();
		if (!startSpinning(document.getElementById('smime-save-submit'))) {
			// Already submitting - do nothing
			return;
		}

        AJS.$.ajax({
            method: 'PUT',
            url: AJS.contextPath() + '/rest/snotify/1.0/uploadSmimeCert?' + AJS.$.param({
		        "atl_token": AJS.$("input[id='smimeToken']").val(),
		    }),
            data: new FormData(this),
            processData: false,
            contentType: false,
            success: function () {
                AJS.messages.success("#jsd-upload-message-context", {
                    title: AJS.I18n.getText('jsd-portal-email-security.success.smime.upload.title'),
                    body: '<p>' + AJS.I18n.getText('jsd-portal-email-security.success.smime.upload.message') + '</p>',
                    closeable: false
                });
                stopSpinning();
            },
            error: function (data) {
                AJS.messages.error("#jsd-upload-message-context", {
                    title: AJS.I18n.getText('jsd-portal-email-security.error.smime.upload.title'),
                    body: '<p>' + data.responseText + '</p>',
                    closeable: false
                });
                stopSpinning();
            }
        });
    });

	// Uploading PGP key
    AJS.$('body').on('submit', '#pgp_form_dialog', function (e) {
        e.preventDefault();

        resetMessage();
		if (!startSpinning(document.getElementById('pgp-save-submit'))) {
			// Already submitting - do nothing
			return;
		}

        AJS.$.ajax({
            method: 'PUT',
            url: AJS.contextPath() + '/rest/snotify/1.0/uploadPgpKey?' + AJS.$.param({
		        "atl_token": AJS.$("input[id='pgpToken']").val(),
		    }),
            data: new FormData(this),
            processData: false,
            contentType: false,
            success: function () {
                AJS.messages.success("#jsd-upload-message-context", {
                    title: AJS.I18n.getText('jsd-portal-email-security.success.pgp.upload.title'),
                    body: '<p>' + AJS.I18n.getText('jsd-portal-email-security.success.pgp.upload.message') + '</p>',
                    closeable: false
                });
                stopSpinning();
            },
            error: function (data) {
                AJS.messages.error("#jsd-upload-message-context", {
                    title: AJS.I18n.getText('jsd-portal-email-security.error.pgp.upload.title'),
                    body: '<p>' + data.responseText + '</p>',
                    closeable: false
                });
                stopSpinning();
            }
        });
    });

	// Deleting S/MIME cert
    AJS.$('body').on('click', '#smime-save-delete', function (e) {
		e.preventDefault();

        resetMessage();
        if (!startSpinning(this)) {
			// Already deleting - do nothing
			return;
		}
		
		AJS.$.ajax({
            method: 'DELETE',
            url: AJS.contextPath() + '/rest/snotify/1.0/deleteSmimeCert?' + AJS.$.param({
		        "atl_token": AJS.$("input[id='smimeToken']").val(),
		    }),
            processData: false,
            success: function () {
                AJS.messages.success("#jsd-upload-message-context", {
                    title: AJS.I18n.getText('jsd-portal-email-security.success.smime.delete.title'),
                    body: '<p>' + AJS.I18n.getText('jsd-portal-email-security.success.smime.delete.message') + '</p>',
                    closeable: false
                });
                stopSpinning();
            },
            error: function (data) {
                console.log(data);
                AJS.messages.error("#jsd-upload-message-context", {
                    title: AJS.I18n.getText('jsd-portal-email-security.error.smime.delete.title'),
                    body: '<p>' + data.responseText + '</p>',
                    closeable: false
                });
                stopSpinning();
            }
        });
    })

	// Delete PGP key
    AJS.$('body').on('click', '#pgp-save-delete', function (e) {
		e.preventDefault();

        resetMessage();		
		if (!startSpinning(this)) {
			// Already deleting - do nothing
			return;
		}

		AJS.$.ajax({
            method: 'DELETE',
            url: AJS.contextPath() + '/rest/snotify/1.0/deletePgpKey?' + AJS.$.param({
		        "atl_token": AJS.$("input[id='pgpToken']").val(),
		    }),
            processData: false,
            success: function () {
                AJS.messages.success("#jsd-upload-message-context", {
                    title: AJS.I18n.getText('jsd-portal-email-security.success.pgp.delete.title'),
                    body: '<p>' + AJS.I18n.getText('jsd-portal-email-security.success.pgp.delete.message') + '</p>',
                    closeable: false
                });
                stopSpinning();
            },
            error: function (data) {
            	console.log(data);
                AJS.messages.error("#jsd-upload-message-context", {
                    title: AJS.I18n.getText('jsd-portal-email-security.error.pgp.delete.title'),
                    body: '<p>' + data.responseText + '</p>',
                    closeable: false
                })
                stopSpinning();
            }
        });

    })

	// Close S/MIME
    AJS.$('body').on('click', '#smime-save-close', function (e) {
        e.preventDefault();
        AJS.dialog2('#pgp_smime_edit_view').hide();
        window.location.reload()
    })

	// Close PGP
    AJS.$('body').on('click', '#pgp-save-close', function (e) {
        e.preventDefault();
        AJS.dialog2('#pgp_smime_edit_view').hide();
        window.location.reload()
    })

	// Switch tab to S/MIME
    AJS.$('body').on('click', '#tabs-menu-smime-link', function (e) {
        e.preventDefault();
		displayTab('smime');
    });
    
	// Switch tab to PGP
    AJS.$('body').on('click', '#tabs-menu-pgp-link', function (e) {
        e.preventDefault();
		displayTab('pgp');
    });
})