/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.encrypt;

import jakarta.mail.MessagingException;
import jakarta.mail.Part;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import net.savignano.cryptography.LazyLog;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.mail.encrypt.AMailEncryptor;
import net.savignano.cryptography.mail.encrypt.SmimeEncryptionResult;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.bc.BcCMSContentEncryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.cms.bc.BcRSAKeyTransRecipientInfoGenerator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEEnvelopedGenerator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEException;
import net.savignano.thirdparty.org.bouncycastle.operator.OutputEncryptor;
import org.slf4j.Logger;

public class SmimeMailEncryptor
extends AMailEncryptor<SmimeEncryptionKey, SmimeEncryptionResult> {
    private ASN1ObjectIdentifier forceSymmetricKeyAlgorithm;
    private int forceSymmetricKeySize;

    public SmimeMailEncryptor(Session session) {
        super(session, ECryptographyType.SMIME);
    }

    @Override
    protected SmimeEncryptionResult createResult(MimeMessage msg) {
        return new SmimeEncryptionResult(msg);
    }

    @Override
    protected void encrypt(Collection<SmimeEncryptionKey> keys, SmimeEncryptionResult result) throws Exception {
        SMIMEEnvelopedGenerator gen = this.createEnvelope(keys);
        OutputEncryptor encryptor = this.createOutputEncryptor(result);
        this.encryptMsg(result.getMessage(), gen, encryptor);
        this.includeEncryptionHeader(result.getMessage(), SmimeUtil.getCmsName(encryptor.getAlgorithmIdentifier().getAlgorithm()));
    }

    private SMIMEEnvelopedGenerator createEnvelope(Collection<SmimeEncryptionKey> keys) throws IOException, CertificateEncodingException {
        SMIMEEnvelopedGenerator gen = new SMIMEEnvelopedGenerator();
        for (SmimeEncryptionKey key : keys) {
            X509Certificate cert = key.getKey();
            this.getLog().debug("Using certificate {} for: {}", (Object)new LazyLog(() -> SmimeUtil.getSerialNumber(cert)), (Object)new LazyLog(() -> SmimeUtil.getSubject(cert)));
            BcRSAKeyTransRecipientInfoGenerator infoGenerator = new BcRSAKeyTransRecipientInfoGenerator(new JcaX509CertificateHolder(cert));
            gen.addRecipientInfoGenerator(infoGenerator);
        }
        return gen;
    }

    private OutputEncryptor createOutputEncryptor(SmimeEncryptionResult result) throws CMSException {
        OutputEncryptor encryptor;
        Logger log = this.getLog();
        ASN1ObjectIdentifier symAlg = this.getForceSymmetricKeyAlgorithm();
        int keySize = this.getForceSymmetricKeySize();
        if (symAlg == null) {
            symAlg = CMSAlgorithm.AES256_CBC;
            keySize = 0;
        }
        log.debug("Used symmetric encryption algorithm: {}", (Object)SmimeUtil.getCmsName(symAlg));
        if (keySize != 0) {
            log.debug("Variable key size used: {}", (Object)keySize);
        }
        result.setSymmetricKeyAlgorithm(symAlg);
        result.setSymmetricKeySize(keySize);
        try {
            encryptor = keySize == 0 ? new BcCMSContentEncryptorBuilder(symAlg).build() : new BcCMSContentEncryptorBuilder(symAlg, keySize).build();
        }
        catch (CMSException e) {
            if (e.getMessage().contains("Illegal key size")) {
                log.debug(e.getMessage(), (Throwable)e);
                log.warn("\"Java Cryptography Extension (JCE) Unlimited Strength\" is not installed on this machine. {} encryption cannot be used. Using fallback AES128_CBC encryption algorithm.", (Object)SmimeUtil.getCmsName(symAlg));
                try {
                    encryptor = new BcCMSContentEncryptorBuilder(CMSAlgorithm.AES128_CBC).build();
                }
                catch (CMSException e1) {
                    String errMsg = "Could not create fallback content encryptor. Error message: " + e1.getMessage();
                    throw new CMSException(errMsg, e);
                }
            }
            throw e;
        }
        return encryptor;
    }

    private void encryptMsg(MimeMessage msg, SMIMEEnvelopedGenerator gen, OutputEncryptor encryptor) throws IOException, MessagingException, SMIMEException {
        this.getLog().debug("Encrypting content.");
        MimeBodyPart tempPart = new MimeBodyPart();
        MessageUtil.movePart((Part)msg, (Part)tempPart);
        MessageUtil.copyAllHeaders((Part)msg, (Part)tempPart);
        MimeBodyPart encryptedBody = gen.generate(tempPart, encryptor);
        MessageUtil.movePart((Part)encryptedBody, (Part)msg);
    }

    public ASN1ObjectIdentifier getForceSymmetricKeyAlgorithm() {
        return this.forceSymmetricKeyAlgorithm;
    }

    public void setForceSymmetricKeyAlgorithm(ASN1ObjectIdentifier forceSymmetricKeyAlgorithm) {
        this.forceSymmetricKeyAlgorithm = forceSymmetricKeyAlgorithm;
    }

    public int getForceSymmetricKeySize() {
        return this.forceSymmetricKeySize;
    }

    public void setForceSymmetricKeySize(int forceSymmetricKeySize) {
        this.forceSymmetricKeySize = forceSymmetricKeySize;
    }
}

