/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.visitor;

import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import net.savignano.cryptography.mail.visitor.MimeMessageVisitor;

public class ContentTypeVisitor
extends MimeMessageVisitor {
    private String contentType;

    @Override
    public void visit(MimePart part) throws Exception {
        super.visit(part);
        ContentType contentType = new ContentType(part.getContentType());
        this.getLog().trace("Part Content Type: {}", (Object)contentType);
        if (this.isRelevant(contentType)) {
            this.handlePart(part);
        }
    }

    @Override
    public void visit(MimeMultipart mp) throws Exception {
        super.visit(mp);
        ContentType contentType = new ContentType(mp.getContentType());
        this.getLog().trace("Multipart Content Type: {}", (Object)contentType);
        if (this.isRelevant(contentType)) {
            this.handleMultipart(mp);
        }
    }

    protected boolean isRelevant(ContentType type) {
        return this.getContentType() == null || type.match(this.getContentType());
    }

    protected void handleMultipart(MimeMultipart mp) throws Exception {
    }

    protected void handlePart(MimePart part) throws Exception {
    }

    protected String getContentType() {
        return this.contentType;
    }

    protected void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

