/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.user.ApplicationUser;
import jakarta.mail.Session;
import jakarta.mail.internet.AddressException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.PKIXParameters;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.key.pgp.PgpValidationKey;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.mail.validate.IMailValidator;
import net.savignano.cryptography.mail.validate.SmimeMailValidator;
import net.savignano.cryptography.mail.visitor.extract.PgpMailExtractor;
import net.savignano.cryptography.mail.visitor.extract.SmimeMailExtractor;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.security.access.pgp.PgpUserKeyLoader;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeUserKeyLoader;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.atlassian.common.user.VirtualUser;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpPublicKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpValidationKeyManager;
import net.savignano.snotify.jira.common.JiraUser;
import net.savignano.snotify.jira.mailer.MessageStoreTransformerConfiguration;
import net.savignano.snotify.jira.mailer.decorator.DecoratorData;
import net.savignano.snotify.jira.mailer.decrypt.AComposedMailDecryptor;
import net.savignano.snotify.jira.mailer.decrypt.ComposedMailDecryptor;
import net.savignano.snotify.jira.mailer.extract.ComposedMailExtractor;
import net.savignano.snotify.jira.mailer.validate.AtlassianPgpMailValidator;
import net.savignano.snotify.jira.mailer.validate.ComposedMailValidator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlassianIncomingMailHandler {
    private static final Logger log = LoggerFactory.getLogger(AtlassianIncomingMailHandler.class);
    private final ISnotifyAppProperties appProps;
    private final ISnotifyUserProperties userProps;

    public AtlassianIncomingMailHandler(ISnotifyAppProperties appProperties, ISnotifyUserProperties userProperties) {
        this.appProps = appProperties;
        this.userProps = userProperties;
    }

    public MessageStoreTransformerConfiguration createConfiguration() {
        MessageStoreTransformerConfiguration configuration = new MessageStoreTransformerConfiguration(this::getMailDecryptor, this::getMailValidator, this::getMailExtractor);
        configuration.setPublicKeyConsumer(this::handleExtractedPublicKeys);
        configuration.setDisabled(this.appProps.getBoolean(EProperty.DISABLE_SNOTIFY));
        configuration.setFrozen(this.appProps.getBoolean(EProperty.FREEZE_SNOTIFY));
        configuration.setLite(this.appProps.getBoolean(EProperty.LITE_MODE));
        configuration.setRemoveSignature(this.appProps.getBoolean(EProperty.REMOVE_SIGNATURES));
        configuration.setExtractPublicKey(this.appProps.getBoolean(EProperty.EXTRACT_PUBLIC_KEY_FROM_SIGNATURES) || this.appProps.getBoolean(EProperty.EXTRACT_CERTIFICATE_FROM_SIGNATURES));
        configuration.setCheckOnlySignature(this.appProps.getBoolean(EProperty.TWEAK_SMIME_IGNORE_CERT_PATH_VALIDATION));
        configuration.setTreatDecryptionWarningAsFailure(this.appProps.getBoolean(EProperty.TWEAK_PGP_PREFERRED_CIPHERS_ONLY));
        configuration.setCheckPgpInline(this.appProps.getBoolean(EProperty.TWEAK_PGP_INLINE_SUPPORT));
        configuration.setPgpBinaryAttachmentRegex(this.appProps.getString(EProperty.TWEAK_PGP_BINARY_REGEX));
        if (this.appProps.getBoolean(EProperty.DECORATE_RECEIVED_MAILS) && this.appProps.hasKey(EProperty.GUI_KEY)) {
            DecoratorData data = new DecoratorData();
            data.displayMissingProtection = this.appProps.getBoolean(EProperty.TWEAK_RECEIVED_MAILS_EXTENDED_DECORATION);
            configuration.setDecoratorData(data);
        }
        return configuration;
    }

    private AComposedMailDecryptor getMailDecryptor(Session session) {
        return new ComposedMailDecryptor(session, this.appProps);
    }

    private ComposedMailValidator getMailValidator(Session session) {
        ComposedMailValidator validator = new ComposedMailValidator();
        validator.setCheckPgpInline(this.appProps.getBoolean(EProperty.TWEAK_PGP_INLINE_SUPPORT));
        validator.setPgpValidatorSupplier(() -> this.getPgpValidator(session));
        validator.setSmimeValidatorSupplier(() -> this.getSmimeValidator(session));
        return validator;
    }

    private ComposedMailExtractor getMailExtractor(Session session) {
        ComposedMailExtractor extractor = new ComposedMailExtractor();
        extractor.setCheckPgpInline(this.appProps.getBoolean(EProperty.TWEAK_PGP_INLINE_SUPPORT));
        extractor.setPgpExtractorSupplier(() -> new PgpMailExtractor(session));
        extractor.setSmimeExtractorSupplier(() -> new SmimeMailExtractor(session));
        return extractor;
    }

    private IMailValidator<PgpEncryptionKey> getPgpValidator(Session session) {
        AtlassianPgpMailValidator validator = new AtlassianPgpMailValidator(session);
        validator.setCheckInline(this.appProps.getBoolean(EProperty.TWEAK_PGP_INLINE_SUPPORT));
        PgpValidationKeyManager valManager = new PgpValidationKeyManager(this.appProps);
        validator.setValidationKeyRetriever(id -> (IPublicCryptographyKey)valManager.getKey(id));
        PgpPublicKeyManager userManager = new PgpPublicKeyManager(this.appProps, this.userProps);
        validator.setUserKeyRetriever((id, email) -> {
            PGPPublicKey neededKey;
            PgpEncryptionKey key;
            PGPPublicKeyRing ring;
            IUser<ApplicationUser> user = JiraUser.lookupUser(email);
            if (user == null) {
                try {
                    user = new VirtualUser((String)email);
                }
                catch (AddressException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    return new PgpValidationKey(EKeyValidity.ERROR);
                }
            }
            if ((ring = (key = (PgpEncryptionKey)userManager.getKey(user)).getKeyRing()) != null && (neededKey = ring.getPublicKey((long)id)) != null) {
                return new PgpValidationKey(neededKey);
            }
            return new PgpValidationKey(EKeyValidity.NOT_FOUND);
        });
        return validator;
    }

    private IMailValidator<SmimeEncryptionKey> getSmimeValidator(Session session) {
        KeyStore javaTrustStore = null;
        try {
            javaTrustStore = SecurityUtil.getJavaTrustStore();
        }
        catch (Exception e) {
            log.error("Could not load java trust store. Certificate Chain will not be validated. Error message: " + e.getMessage(), (Throwable)e);
        }
        PKIXParameters params = null;
        if (javaTrustStore != null) {
            try {
                params = new PKIXParameters(javaTrustStore);
                params.setRevocationEnabled(this.appProps.getBoolean(EProperty.TWEAK_CERTIFICATION_REVOCATION_ENABLED));
            }
            catch (Exception e) {
                log.error("Could not create validation parameters. Certification chain will not be validated. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        return new SmimeMailValidator(session, params);
    }

    private void handleExtractedPublicKeys(IPublicCryptographyKey<?> key, String email) {
        if (key == null || !key.isValid()) {
            return;
        }
        if (key instanceof SmimeEncryptionKey) {
            if (this.appProps.getBoolean(EProperty.EXTRACT_CERTIFICATE_FROM_SIGNATURES)) {
                for (JiraUser user : JiraUser.lookupUsers(email)) {
                    SmimeUserKeyLoader loader = new SmimeUserKeyLoader(this.userProps);
                    this.storeKey((SmimeEncryptionKey)key, user, (SmimeEncryptionKey)loader.loadKey(user), this::setSmime, this::equalsSmime);
                }
                log.debug("Caching S/MIME certificate for email {}, should user be created.", (Object)email);
                CacheFactory factory = (CacheFactory)ComponentAccessor.getComponent(CacheFactory.class);
                Cache cache = factory.getCache("net.savignano.snotify.jira.cache.pgp.incomingMail");
                cache.put((Object)email, (Object)((SmimeEncryptionKey)key).getKey());
            }
        } else if (key instanceof PgpEncryptionKey) {
            if (this.appProps.getBoolean(EProperty.EXTRACT_PUBLIC_KEY_FROM_SIGNATURES)) {
                for (JiraUser user : JiraUser.lookupUsers(email)) {
                    PgpUserKeyLoader loader = new PgpUserKeyLoader(this.userProps);
                    this.storeKey((PgpEncryptionKey)key, user, (PgpEncryptionKey)loader.loadKey(user), this::setPgp, this::equalsPgp);
                }
                log.debug("Caching PGP key for email {}, should user be created.", (Object)email);
                CacheFactory factory = (CacheFactory)ComponentAccessor.getComponent(CacheFactory.class);
                Cache cache = factory.getCache("net.savignano.snotify.jira.cache.smime.incomingMail");
                try {
                    cache.put((Object)email, (Object)((PgpEncryptionKey)key).getEncoded());
                }
                catch (IOException e) {
                    log.error("Could not encoded public PGP key. Error message: " + e.getMessage(), (Throwable)e);
                }
            }
        } else {
            log.error("Unknown public key encountered: {}", key);
        }
    }

    private <T extends ICryptographyKey<?>> void storeKey(T key, IUser<?> user, T cachedKey, BiConsumer<T, IUser<?>> setter, BiFunction<T, T, Boolean> equals) {
        log.debug("Currently cached key for user {}: {}", user, cachedKey);
        if (cachedKey.isValid()) {
            if (cachedKey.getKeySource() != EKeySource.USER) {
                if (!equals.apply(key, cachedKey).booleanValue()) {
                    setter.accept(key, user);
                } else {
                    log.debug("Cached key is same as extracted key. No storing needed.");
                }
            }
        } else {
            setter.accept(key, user);
        }
    }

    private boolean equalsSmime(SmimeEncryptionKey key, SmimeEncryptionKey otherKey) {
        return key.getKey().getSerialNumber().equals(otherKey.getKey().getSerialNumber());
    }

    private void setSmime(SmimeEncryptionKey key, IUser<?> user) {
        log.info("Setting S/MIME certificate for user: {}", (Object)user.getDisplayName());
        try {
            this.userProps.setBytes(EProperty.EMAIL_SMIME_CERT, key.getEncoded(), user);
            this.userProps.setLong(EProperty.EMAIL_SMIME_TIME_STAMP, System.currentTimeMillis(), user);
            this.userProps.setEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, key.getKeySource(), user);
        }
        catch (IOException e) {
            log.error("Could not set S/MIME certificate for user: " + user.getDisplayName() + ". Error message: " + e.getMessage(), (Throwable)e);
        }
    }

    private Boolean equalsPgp(PgpEncryptionKey key, PgpEncryptionKey otherKey) {
        return key.getKey().getKeyID() == otherKey.getKey().getKeyID() && key.getMasterKey().getKeyID() == otherKey.getMasterKey().getKeyID();
    }

    private void setPgp(PgpEncryptionKey key, IUser<?> user) {
        log.info("Setting PGP key for user: {}", (Object)user.getDisplayName());
        try {
            this.userProps.setBytes(EProperty.EMAIL_PGP_KEY, key.getEncoded(), user);
            this.userProps.setLong(EProperty.EMAIL_PGP_KEY_ID, key.getKey().getKeyID(), user);
            this.userProps.setLong(EProperty.EMAIL_PGP_TIME_STAMP, System.currentTimeMillis(), user);
            this.userProps.setEnum(EProperty.EMAIL_PGP_KEY_SOURCE, key.getKeySource(), user);
        }
        catch (IOException e) {
            log.error("Could not set PGP public key for user: " + user.getDisplayName() + ". Error message: " + e.getMessage(), (Throwable)e);
        }
    }
}

