/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.server.SMTPMailServer;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.mail.visitor.RegexVisitor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.version.ProductInformation;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.enums.EEncryptionFailureBehavior;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyProjectProperties;
import net.savignano.snotify.atlassian.common.properties.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.user.IUser;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailKeyExtractor;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailer;
import net.savignano.snotify.atlassian.mailer.MessageAndAddress;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpPublicKeyManager;
import net.savignano.snotify.jira.common.JiraConstants;
import net.savignano.snotify.jira.common.JiraUser;
import net.savignano.snotify.jira.common.SnotifyI18n;
import net.savignano.snotify.jira.mailer.IgnoreEncryptionDetector;
import net.savignano.snotify.jira.mailer.JiraMailIssueExtractor;
import net.savignano.snotify.jira.mailer.JiraMailProjectExtractor;
import net.savignano.snotify.jira.mailer.keysource.smime.JiraSmimeKeyManager;
import net.savignano.snotify.jira.mailer.util.MessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraMailer
extends AAtlassianMailer<JiraUser> {
    private static final Logger log = LoggerFactory.getLogger(JiraMailer.class);
    private static final String PREFIX_REPLACEMENT = "%PREFIX%";
    private static final String TICKET_REPLACEMENT = "%TICKET%";

    public JiraMailer(Session session, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps, ISnotifyProjectProperties projectProps) {
        super(session, appProps, userProps, projectProps);
    }

    @Override
    protected ProductInformation loadProductInformation() {
        return JiraConstants.PRODUCT_INFORMATION;
    }

    @Override
    protected MimeMessage getFailureMessage(MessageAndAddress msgAndAddress, EKeyValidity validity) throws MessagingException {
        I18nHelper i18nHelper;
        JiraUser user = (JiraUser)this.getUser(msgAndAddress.address);
        if (user != null) {
            log.debug("Getting locale for user: {}", (Object)user);
            i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(user.getActualUser());
        } else {
            log.debug("Getting default locale.");
            Locale locale = ComponentAccessor.getLocaleManager().getLocale("-1");
            i18nHelper = ComponentAccessor.getI18nHelperFactory().getInstance(locale);
        }
        log.debug("Used locale for address \"{}\": {}", (Object)msgAndAddress.address, (Object)i18nHelper.getLocale());
        SnotifyI18n i18n = new SnotifyI18n(i18nHelper);
        MessageBuilder builder = new MessageBuilder(msgAndAddress.message, i18n, this.getBaseUrl());
        builder.additional(this.getAppProps().getString(EProperty.TWEAK_REPORT_MESSAGE_ADDITIONAL_TEXT));
        builder.replace(this.getReplacementFailureMessage(msgAndAddress.address));
        builder.showLink(this.getAppProps().getBoolean(EProperty.REPORT_MESSAGE_SHOW_LINK));
        if (validity == EKeyValidity.ERROR) {
            return builder.buildInternalErrorInfoMail();
        }
        boolean jsmCustomer = this.isJsmCustomer(msgAndAddress.message);
        builder.encryptionType(this.getTypePriority());
        builder.jsmCustomer(jsmCustomer);
        builder.editPgpInfo(this.getAppProps().getBoolean(jsmCustomer ? EProperty.ALLOW_JSD_PGP_PUBLIC_KEY_OVERWRITE : EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE));
        builder.editSmimeInfo(this.getAppProps().getBoolean(jsmCustomer ? EProperty.ALLOW_JSD_SMIME_CERTIFICATE_OVERWRITE : EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE));
        return builder.buildMissingKeyInfoMail();
    }

    private String getReplacementFailureMessage(Address address) {
        if (this.isEmailBlocked(address) == EEncryptionFailureBehavior.REPORT && this.getAppProps().hasKey(EProperty.TWEAK_REPORT_MESSAGE_DOMAIN_BLOCK_TEXT)) {
            return this.getAppProps().getString(EProperty.TWEAK_REPORT_MESSAGE_DOMAIN_BLOCK_TEXT);
        }
        return this.getAppProps().getString(EProperty.TWEAK_REPORT_MESSAGE_REPLACE_TEXT);
    }

    private boolean isJsmCustomer(MimeMessage msg) {
        Pattern pattern = Pattern.compile("(?:^|[\"\\s])(" + this.getBaseUrl() + "[^\"\\s]+)");
        RegexVisitor visitor = new RegexVisitor(pattern);
        try {
            visitor.visit(msg);
        }
        catch (Exception e) {
            log.error("Could not check if message is for a Service Manager Customer. Error message: " + e.getMessage(), (Throwable)e);
            return false;
        }
        List matches = (List)visitor.getResult();
        if (matches.isEmpty()) {
            return false;
        }
        for (MatchResult match : matches) {
            if (match.group().contains("servicedesk/customer/portal")) continue;
            return false;
        }
        return true;
    }

    @Override
    protected SmimeEncryptionKey getSmimeEncryptionKey(Address to) {
        IUser<?> user = this.virtualUser(to);
        JiraSmimeKeyManager manager = new JiraSmimeKeyManager(this.getAppProps(), this.getUserProps());
        return (SmimeEncryptionKey)manager.getKey(user);
    }

    @Override
    protected List<String> extractProjectKeys(MimeMessage msg) {
        String baseUrl = this.getBaseUrl();
        log.debug("Extracting project keys.");
        JiraMailProjectExtractor extractor = new JiraMailProjectExtractor(baseUrl);
        List<String> keys = this.extractKeys(msg, extractor);
        if (keys.size() <= 1) {
            return keys;
        }
        String issueId = this.getSubjectIssue(msg, baseUrl);
        if (issueId != null) {
            MutableIssue issue = ComponentAccessor.getIssueManager().getIssueByCurrentKey(issueId);
            if (issue != null) {
                String projectKey = issue.getProjectObject().getKey();
                log.debug("Issue with ID {} belongs to project: {}", (Object)issueId, (Object)projectKey);
                return Collections.singletonList(projectKey);
            }
            log.debug("Issue with ID {} does not exist.", (Object)issueId);
        }
        return keys;
    }

    @Override
    protected List<JiraUser> getUsers(Address address) {
        return JiraUser.lookupUsers(address);
    }

    @Override
    protected boolean hasValidKey(JiraUser user, ECryptographyType cryptography) {
        switch (cryptography) {
            case NONE: {
                return false;
            }
            case PGP: {
                return ((PgpEncryptionKey)new PgpPublicKeyManager(this.getAppProps(), this.getUserProps()).getKey(user)).isValid();
            }
            case SMIME: {
                return ((SmimeEncryptionKey)new JiraSmimeKeyManager(this.getAppProps(), this.getUserProps()).getKey(user)).isValid();
            }
        }
        log.error("Unhandled cryptography: {}", (Object)cryptography);
        return false;
    }

    @Override
    protected boolean isEncryptionDesired(MessageAndAddress msgAndAddress) {
        if (!super.isEncryptionDesired(msgAndAddress)) {
            return false;
        }
        if (!this.isEncryptionDesiredWhitelistGroup(msgAndAddress)) {
            return false;
        }
        return this.isEncryptionDesiredPasswordResetMail(msgAndAddress);
    }

    private boolean isEncryptionDesiredWhitelistGroup(MessageAndAddress msgAndAddress) {
        JiraUser user;
        String whitelistUserGroup = this.getAppProps().getString(EProperty.WHITELIST_USER_GROUP);
        if (whitelistUserGroup != null && (user = (JiraUser)this.getUser(msgAndAddress.address)) != null) {
            GroupManager manager = ComponentAccessor.getGroupManager();
            if (manager.groupExists(whitelistUserGroup)) {
                boolean member = manager.isUserInGroup(user.getActualUser(), whitelistUserGroup);
                log.debug("User {} is in group {}: {}", new Object[]{user, whitelistUserGroup, member});
                return !member;
            }
            log.warn("Group {} does not exist.", (Object)whitelistUserGroup);
        }
        return true;
    }

    private boolean isEncryptionDesiredPasswordResetMail(MessageAndAddress msgAndAddress) {
        if (!this.getAppProps().getBoolean(EProperty.ALLOW_PASSWORD_RESET_MAIL)) {
            return true;
        }
        boolean ignoreEncryption = new IgnoreEncryptionDetector(this.getBaseUrl()).isIgnoreEncryptionEmail(msgAndAddress.message);
        log.debug("Message with ID \"{}\" is considered a 'password reset email': {}", (Object)MessageUtil.getMessageId((Message)msgAndAddress.message), (Object)ignoreEncryption);
        return !ignoreEncryption;
    }

    @Override
    protected String getSubjectReplacement(MimeMessage msg) {
        Object replacement = super.getSubjectReplacement(msg);
        if (replacement != null && this.getAppProps().getBoolean(EProperty.SUBJECT_PROTECTION_KEEP_ID)) {
            if (this.getAppProps().getString(EProperty.TWEAK_SUBJECT_PROTECTION_REPLACEMENT) == null) {
                replacement = "%PREFIX% (%TICKET%) " + (String)replacement;
            }
            log.debug("Subject replacement pattern: {}", replacement);
            replacement = this.replacePrefix((String)replacement);
            replacement = this.replaceTicket(msg, (String)replacement);
            replacement = ((String)replacement).replace(" ()", "");
        }
        return replacement;
    }

    private String replacePrefix(String replacement) {
        int index = replacement.indexOf(PREFIX_REPLACEMENT);
        if (index == -1) {
            return replacement;
        }
        SMTPMailServer server = ComponentAccessor.getMailServerManager().getDefaultSMTPMailServer();
        if (server == null) {
            log.error("No default SMTP server configured.");
            return replacement.replace(PREFIX_REPLACEMENT, "");
        }
        String prefix = server.getPrefix();
        log.debug("Used Prefix of default SMPT server: {}", (Object)prefix);
        return replacement.replace(PREFIX_REPLACEMENT, prefix == null ? "" : prefix);
    }

    private String replaceTicket(MimeMessage msg, String replacement) {
        int index = replacement.indexOf(TICKET_REPLACEMENT);
        if (index == -1) {
            return replacement;
        }
        log.debug("Extracting primary issue key.");
        String baseUrl = this.getBaseUrl();
        String issueId = this.getSubjectIssue(msg, baseUrl);
        return replacement.replace(TICKET_REPLACEMENT, issueId == null ? "" : issueId);
    }

    private String getSubjectIssue(MimeMessage msg, String baseUrl) {
        JiraMailIssueExtractor extractor = new JiraMailIssueExtractor(baseUrl);
        List<String> keys = this.extractKeys(msg, extractor);
        String subject = null;
        try {
            subject = msg.getSubject();
        }
        catch (MessagingException e) {
            log.error("Could not get subject from email. Error message: " + e.getMessage(), (Throwable)e);
        }
        log.debug("Looking for issue reference in subject: {}", (Object)subject);
        String issueId = null;
        if (subject != null) {
            for (String key : keys) {
                if (!subject.contains(key)) continue;
                issueId = key;
                break;
            }
        }
        log.debug("Issue ID from subject: {}", issueId);
        return issueId;
    }

    private List<String> extractKeys(MimeMessage msg, AAtlassianMailKeyExtractor extractor) {
        Set<String> keys;
        String msgId = MessageUtil.getMessageId((Message)msg);
        try {
            keys = extractor.getKeys(msg);
        }
        catch (Exception e) {
            log.error("Could not extract keys for message with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
            keys = Collections.emptySet();
        }
        log.debug("Reference(s) found in message with ID \"{}\": {}", (Object)msgId, keys);
        return new ArrayList<String>(keys);
    }

    private String getBaseUrl() {
        return ComponentAccessor.getApplicationProperties().getString("jira.baseurl");
    }
}

