/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer;

import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.enums.EValidationType;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.mail.expose.AMailHeaderExposer;
import net.savignano.cryptography.mail.expose.PgpMailHeaderExposer;
import net.savignano.cryptography.mail.expose.SmimeMailHeaderExposer;
import net.savignano.cryptography.mail.visitor.specific.DetectCryptographyVisitor;
import net.savignano.cryptography.mail.visitor.specific.InlineSignatureConverter;
import net.savignano.cryptography.mail.visitor.specific.OpaqueSignatureConverter;
import net.savignano.cryptography.mail.visitor.specific.SignatureRemover;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.snotify.atlassian.common.security.ClassLoaderEnforcer;
import net.savignano.snotify.atlassian.mailer.SnotifyMimeMessage;
import net.savignano.snotify.jira.mailer.MessageStoreTransformerConfiguration;
import net.savignano.snotify.jira.mailer.decorator.CryptographyDecoration;
import net.savignano.snotify.jira.mailer.decorator.EIconDecorator;
import net.savignano.snotify.jira.mailer.decorator.MessageDecoratorHelper;
import net.savignano.snotify.jira.mailer.decrypt.AComposedMailDecryptor;
import net.savignano.snotify.jira.mailer.decrypt.IComposedMailDecryptor;
import net.savignano.snotify.jira.mailer.extract.ComposedMailExtractor;
import net.savignano.snotify.jira.mailer.extract.IComposedMailExtractor;
import net.savignano.snotify.jira.mailer.validate.ComposedMailValidator;
import net.savignano.snotify.jira.mailer.validate.IComposedMailValidator;
import net.savignano.snotify.jira.mailer.validate.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageStoreTransformer<T extends Message> {
    private static final Logger log = LoggerFactory.getLogger(MessageStoreTransformer.class);
    private final MessageStoreTransformerConfiguration configuration;
    private Session cachedSession;
    private AComposedMailDecryptor cachedDecryptor;
    private ComposedMailValidator cachedValidator;
    private ComposedMailExtractor cachedExtractor;
    private MessageDecoratorHelper decoHelper;

    public MessageStoreTransformer(MessageStoreTransformerConfiguration configuration) {
        this.configuration = configuration;
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration must not be null.");
        }
        if (configuration.getDecoratorData() != null) {
            this.decoHelper = new MessageDecoratorHelper(configuration.getDecoratorData());
        }
    }

    public Message[] transformMessages(Message[] orgMsgs) {
        if (orgMsgs == null) {
            log.warn("Cannot transform messages, null parameter received.");
            return null;
        }
        log.debug("Using configuration: {}", (Object)this.configuration);
        log.debug("Getting {} message(s).", (Object)orgMsgs.length);
        if (orgMsgs.length != 0 && this.sanityCheckSnotify()) {
            return this.runWithThisClassLoaderContext(this::transformMsgsUnsafe, orgMsgs);
        }
        return orgMsgs;
    }

    private Message[] transformMsgsUnsafe(Message[] orgMsgs) {
        Message[] msgs = new Message[orgMsgs.length];
        for (int i = 0; i < orgMsgs.length; ++i) {
            int msgNr;
            Message orgMsg = orgMsgs[i];
            int n = msgNr = orgMsg == null ? -1 : orgMsg.getMessageNumber();
            if (this.sanityCheckMessage(orgMsg)) {
                log.debug("Getting message (index {}) with number {}.", (Object)i, (Object)msgNr);
                msgs[i] = this.transformMsgUnsafe(orgMsg);
                log.debug("Gotten message (index {}) with number {}.", (Object)i, (Object)msgNr);
                continue;
            }
            log.debug("Using message (index {}) with number {} as is.", (Object)i, (Object)msgNr);
            msgs[i] = orgMsg;
        }
        return msgs;
    }

    public Message transformMessage(Message orgMsg) {
        log.debug("Using configuration: {}", (Object)this.configuration);
        if (this.sanityCheckSnotify() && this.sanityCheckMessage(orgMsg)) {
            return this.runWithThisClassLoaderContext(this::transformMsgUnsafe, orgMsg);
        }
        return orgMsg;
    }

    private Message transformMsgUnsafe(T orgMsg) {
        String msgId;
        MimeMessage msg;
        try {
            msg = this.loadMessage(orgMsg);
            msgId = MessageUtil.getMessageId((Message)msg);
        }
        catch (Exception e) {
            log.error("Could not load message. Error message: " + e.getMessage(), (Throwable)e);
            return orgMsg;
        }
        try {
            MessageUtil.trace((Message)msg, "Loaded email:", log);
            if (this.decoHelper != null) {
                this.decoHelper.add(EIconDecorator.MESSAGE);
            }
            ECryptographyType cryptography = this.detectCryptography(msg, msgId);
            if (this.decoHelper != null) {
                this.decoHelper.add(new CryptographyDecoration(cryptography));
            }
            msg = this.handleSignatures(msg, msgId);
            msg = this.handleDecryption(msg, msgId);
            msg = this.handleSignatures(msg, msgId);
            msg = this.handleProtectedHeaders(msg, cryptography, msgId);
            msg = this.applyDecorations(msg, msgId);
            try {
                msg = this.wrap(msg, orgMsg);
            }
            catch (Exception e) {
                log.error("Could not bind processed email to original email. Message ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
                return orgMsg;
            }
            MessageUtil.trace((Message)msg, "Processed message:", log);
            return msg;
        }
        catch (Exception e) {
            log.error("Unexpected error processing email with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
            return orgMsg;
        }
    }

    protected boolean sanityCheckSnotify() {
        if (this.configuration.isDisabled()) {
            log.info("S/Notify is disabled. Emails will not be decrypted.");
            return false;
        }
        if (this.configuration.isFrozen()) {
            log.error("Could not decrypt email due to licensing error in S/Notify.");
            return false;
        }
        if (this.configuration.isLite()) {
            log.info("Lite version for S/Notify detected, no decryption will happen.");
            return false;
        }
        return true;
    }

    protected boolean sanityCheckMessage(Message orgMsg) {
        if (orgMsg == null) {
            log.warn("Sanity check failed. Cannot check message, null parameter encountered.");
            return false;
        }
        return true;
    }

    private <S, R> R runWithThisClassLoaderContext(Function<S, R> function, S arg) {
        ClassLoaderEnforcer enforcer = new ClassLoaderEnforcer(this.getClass().getClassLoader());
        return enforcer.run(function, arg);
    }

    private ECryptographyType detectCryptography(MimeMessage msg, String msgId) {
        try {
            DetectCryptographyVisitor visitor = new DetectCryptographyVisitor();
            visitor.setCheckInline(this.configuration.isCheckPgpInline());
            visitor.setBinaryRegex(this.configuration.getPgpBinaryAttachmentRegex());
            visitor.visit(msg);
            return (ECryptographyType)((Object)visitor.getResult());
        }
        catch (Exception e) {
            log.warn("Failed to detect cryptography of email with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
            return ECryptographyType.NONE;
        }
    }

    private MimeMessage safetyCopy(MimeMessage msg, String msgId) {
        try {
            return new SnotifyMimeMessage(msg.getSession(), msg);
        }
        catch (Exception e) {
            log.warn("Could not copy email with ID \"" + msgId + "\". Error message: " + e.getMessage());
            return msg;
        }
    }

    private MimeMessage applyDecorations(MimeMessage msg, String msgId) {
        if (this.decoHelper == null) {
            return msg;
        }
        MimeMessage safetyCopy = this.safetyCopy(msg, msgId);
        try {
            this.decoHelper.apply(msg);
            this.decoHelper.clear();
            return msg;
        }
        catch (Exception e) {
            log.warn("Could not apply decorations to email with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
            return safetyCopy;
        }
    }

    private MimeMessage handleDecryption(MimeMessage msg, String msgId) {
        log.debug("Checking message with ID \"{}\" for encryption.", (Object)msgId);
        IComposedMailDecryptor decryptor = this.getMailDecryptor(msg.getSession());
        if (decryptor == null) {
            log.error("Cannot handle decryption. No decryptor available.");
            return msg;
        }
        if (!decryptor.isEncrypted(msg)) {
            log.debug("Message with ID \"{}\" is not encrypted.", (Object)msgId);
            if (this.decoHelper != null) {
                this.decoHelper.add(EIconDecorator.UNENCRYPTED);
            }
            return msg;
        }
        MimeMessage safetyCopy = this.safetyCopy(msg, msgId);
        try {
            decryptor.decrypt(msg);
            if (this.configuration.isTreatDecryptionWarningAsFailure() && decryptor.isWarning()) {
                log.error("Message with ID \"{}\" was rejected, because it was not encrypted with a preferred cipher.", (Object)msgId);
                if (this.decoHelper != null) {
                    this.decoHelper.add(EIconDecorator.ENCRYPTED_FAILURE);
                }
                return safetyCopy;
            }
            if (this.decoHelper != null) {
                if (decryptor.isWarning()) {
                    log.warn("Message with ID \"{}\" was accepted, but it was not encrypted with a preferred cipher.", (Object)msgId);
                    this.decoHelper.add(EIconDecorator.ENCRYPTED_WARNING);
                } else {
                    this.decoHelper.add(EIconDecorator.ENCRYPTED);
                }
            }
            return msg;
        }
        catch (Exception e) {
            log.warn("Could not decrypt email with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
            if (this.decoHelper != null) {
                if (this.isMissigKeyException(e)) {
                    this.decoHelper.add(EIconDecorator.ENCRYPTED_UNKNOWN);
                } else {
                    this.decoHelper.add(EIconDecorator.ENCRYPTED_FAILURE);
                }
            }
            return safetyCopy;
        }
    }

    private boolean isMissigKeyException(Throwable t) {
        if (t == null) {
            return false;
        }
        String message = t.getMessage();
        if (message != null && message.startsWith("Found no valid private key")) {
            return true;
        }
        return this.isMissigKeyException(t.getCause());
    }

    private MimeMessage handleSignatures(MimeMessage msg, String msgId) {
        boolean valid;
        MimeMessage safetyCopy;
        block12: {
            IComposedMailValidator validator = this.getMailValidator(msg.getSession());
            if (validator == null) {
                log.error("Cannot handle signaturs. No validator available.");
                return msg;
            }
            safetyCopy = this.safetyCopy(msg, msgId);
            valid = false;
            try {
                valid = this.checkSignature(msg, validator, msgId);
            }
            catch (Exception e) {
                log.warn("Unexpected error when checking signature for message with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
                if (this.decoHelper == null) break block12;
                this.decoHelper.add(EIconDecorator.SIGNED_UNVERIFIED);
            }
        }
        if (valid && this.configuration.isExtractPublicKey()) {
            IComposedMailExtractor extractor = this.getMailExtractor(msg.getSession());
            if (extractor != null) {
                try {
                    this.extractKey(msg, extractor, msgId);
                }
                catch (Exception e) {
                    log.warn("Unexpected error when extracing key for message with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
                }
            } else {
                log.warn("Cannot extract public keys. No extractor available.");
            }
        }
        try {
            if (this.configuration.isRemoveSignature()) {
                this.removeSignatures(msg, msgId);
            } else {
                this.convertOpaqueSignature(msg, msgId);
            }
            return msg;
        }
        catch (Exception e) {
            log.warn("Could not remove signature for message with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
            return safetyCopy;
        }
    }

    private boolean checkSignature(MimeMessage msg, IComposedMailValidator validator, String msgId) {
        EIconDecorator icon;
        log.debug("Checking message with ID \"{}\" for signature.", (Object)msgId);
        ValidationResult result = validator.validate(msg);
        boolean valid = result.isValid();
        if (valid) {
            log.debug("Message with ID \"{}\" is correctly signed.", (Object)msgId);
            icon = EIconDecorator.SIGNED;
        } else if (result.getCryptography() == ECryptographyType.NONE) {
            log.debug("Message with ID \"{}\" is not signed.", (Object)msgId);
            icon = EIconDecorator.UNSIGNED;
        } else if (result.getError() != null) {
            log.warn("Validation of message with ID \"" + msgId + "\" had an exception. Error message: " + result.getError().getMessage(), (Throwable)result.getError());
            icon = EIconDecorator.SIGNED_MISMATCH;
        } else {
            Set<EValidationType> validations = result.getValidations();
            if (!validations.contains((Object)EValidationType.CAN_VALIDATE)) {
                log.debug("Message with ID \"{}\" has an unknown sender, cannot verify.", (Object)msgId);
                icon = EIconDecorator.SIGNED_UNKNOWN;
            } else if (!validations.contains((Object)EValidationType.SIGNATURE)) {
                log.warn("Validity of message with ID \"{}\" could not be verified. Message was probably tampered with.", (Object)msgId);
                icon = EIconDecorator.SIGNED_MISMATCH;
            } else if (!validations.contains((Object)EValidationType.EMAIL_ADDRESS)) {
                log.warn("Email address of sender does not match with the signature of message with ID \"{}\". Message was probably tampered with.", (Object)msgId);
                icon = EIconDecorator.SIGNED_MISMATCH;
            } else if (!validations.contains((Object)EValidationType.TRUST)) {
                if (this.configuration.isCheckOnlySignature()) {
                    log.debug("Trust of signer not relevant for message with ID \"{}\".", (Object)msgId);
                    icon = EIconDecorator.SIGNED;
                    valid = true;
                } else {
                    log.warn("Trust of signer of message with ID \"{}\" could not be verified.", (Object)msgId);
                    icon = EIconDecorator.SIGNED_UNVERIFIED;
                }
            } else {
                log.warn("Unknown problem with signature for message with ID \"{}\".", (Object)msgId);
                icon = EIconDecorator.SIGNED_MISMATCH;
            }
        }
        if (this.decoHelper != null) {
            this.decoHelper.add(icon);
        }
        return valid;
    }

    private void extractKey(MimeMessage msg, IComposedMailExtractor extractor, String msgId) {
        if (this.configuration.getPublicKeyConsumer() == null) {
            log.debug("No consumer for public key available. Skipping extraction.");
            return;
        }
        log.debug("Checking message with ID \"{}\" for public key.", (Object)msgId);
        IPublicCryptographyKey<?> publicKey = extractor.extractPublicKey(msg);
        if (publicKey.getKeyValidity() != EKeyValidity.NOT_FOUND) {
            log.info("Found public key in message with ID \"{}\": {}", (Object)msgId, publicKey);
            this.configuration.getPublicKeyConsumer().accept(publicKey, MessageUtil.getFromEmail(msg).get());
        }
    }

    private void removeSignatures(MimeMessage msg, String msgId) throws MessagingException {
        log.debug("Checking message with ID \"{}\" for signatures to remove.", (Object)msgId);
        if (this.configuration.isCheckPgpInline()) {
            InlineSignatureConverter converter = new InlineSignatureConverter();
            try {
                converter.visit(msg);
                if (converter.isChanged()) {
                    log.debug("Converted all inline signatures from message with ID \"{}\".", (Object)msgId);
                } else {
                    log.debug("No inline signature found.");
                }
            }
            catch (Exception e) {
                throw new MessagingException("Could not remove inline signatures from MIME message with ID \"" + msgId + "\". Error message: " + e.getMessage(), e);
            }
        }
        SignatureRemover remover = new SignatureRemover();
        try {
            remover.visit(msg);
            if (remover.isChanged()) {
                log.debug("Removed all signatures from message with ID \"{}\".", (Object)msgId);
            } else {
                log.debug("No signature found.");
            }
        }
        catch (Exception e) {
            throw new MessagingException("Could not remove signatures from MIME message with ID \"" + msgId + "\". Error message: " + e.getMessage(), e);
        }
    }

    private void convertOpaqueSignature(MimeMessage msg, String msgId) throws MessagingException {
        log.debug("Checking message with ID \"{}\" for opaque signatures to convert.", (Object)msgId);
        OpaqueSignatureConverter converter = new OpaqueSignatureConverter();
        try {
            converter.visit(msg);
            if (converter.isChanged()) {
                log.debug("Converted all signatures from message with ID \"{}\".", (Object)msgId);
            } else {
                log.debug("No opaque signature found.");
            }
        }
        catch (Exception e) {
            throw new MessagingException("Could not convert opaque signatures from MIME message with ID \"" + msgId + "\". Error message: " + e.getMessage(), e);
        }
    }

    private IComposedMailValidator getMailValidator(Session session) {
        if (session == null) {
            log.error("Can't get mail validator as no session object has been given.");
            return null;
        }
        if (!Objects.equals(session, this.cachedSession)) {
            log.debug("Session object changed. Invalidating cached mail validator.");
            this.cachedSession = session;
            this.cachedValidator = null;
        }
        if (this.cachedValidator == null) {
            this.cachedValidator = this.configuration.getValidatorFunction().apply(session);
            if (this.cachedValidator != null) {
                this.cachedValidator.setCheckPgpInline(this.configuration.isCheckPgpInline());
            }
        }
        return this.cachedValidator;
    }

    private IComposedMailExtractor getMailExtractor(Session session) {
        if (session == null) {
            log.error("Can't get mail extractor as no session object has been given.");
            return null;
        }
        if (!Objects.equals(session, this.cachedSession)) {
            log.debug("Session object changed. Invalidating cached mail extractor.");
            this.cachedSession = session;
            this.cachedExtractor = null;
        }
        if (this.cachedExtractor == null) {
            this.cachedExtractor = this.configuration.getExtractorFunction().apply(session);
            if (this.cachedExtractor != null) {
                this.cachedExtractor.setCheckPgpInline(this.configuration.isCheckPgpInline());
            }
        }
        return this.cachedExtractor;
    }

    private IComposedMailDecryptor getMailDecryptor(Session session) {
        if (session == null) {
            log.error("Can't get mail decryptor as no session object has been given.");
            return null;
        }
        if (!Objects.equals(session, this.cachedSession)) {
            log.debug("Session object changed. Invalidating cached mail decryptor.");
            this.cachedSession = session;
            this.cachedDecryptor = null;
        }
        if (this.cachedDecryptor == null) {
            this.cachedDecryptor = this.configuration.getDecryptorFunction().apply(session);
            if (this.cachedDecryptor != null) {
                this.cachedDecryptor.setCheckPgpInline(this.configuration.isCheckPgpInline());
                this.cachedDecryptor.setCheckPgpBinaryAttachment(this.configuration.getPgpBinaryAttachmentRegex());
            }
        }
        return this.cachedDecryptor;
    }

    private MimeMessage handleProtectedHeaders(MimeMessage msg, ECryptographyType type, String msgId) {
        AMailHeaderExposer exposer = switch (type) {
            case ECryptographyType.PGP -> new PgpMailHeaderExposer();
            case ECryptographyType.SMIME -> new SmimeMailHeaderExposer();
            default -> null;
        };
        if (exposer != null) {
            MimeMessage safetyCopy = this.safetyCopy(msg, msgId);
            try {
                exposer.exposeHeaders(msg);
            }
            catch (Exception e) {
                log.warn("Could not expose protected headers of email with ID \"" + msgId + "\". Error message: " + e.getMessage(), (Throwable)e);
                return safetyCopy;
            }
        }
        return msg;
    }

    protected MimeMessage loadMessage(T orgMsg) throws MessagingException {
        log.debug("Loading message {}.", (Object)orgMsg.getMessageNumber());
        if (orgMsg instanceof MimeMessage) {
            return new SnotifyMimeMessage(orgMsg.getSession(), (MimeMessage)orgMsg);
        }
        log.warn("Did not encounter a MIME message. Found message of type: {}.", orgMsg.getClass());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        try {
            orgMsg.writeTo((OutputStream)baos);
        }
        catch (IOException e) {
            throw new MessagingException("Could not read message with number: " + orgMsg.getMessageNumber(), (Exception)e);
        }
        return new SnotifyMimeMessage(orgMsg.getSession(), new ByteArrayInputStream(baos.toByteArray()));
    }

    protected MimeMessage wrap(MimeMessage processedMsg, T orgMsg) throws MessagingException {
        return processedMsg;
    }

    public Message[] unwrap(Message[] msgs) throws MessagingException {
        if (msgs == null) {
            log.warn("Cannot unwrap messages, null parameter received.");
            return null;
        }
        log.debug("Unwrapping {} message(s).", (Object)msgs.length);
        Message[] unwrappedMsgs = new Message[msgs.length];
        for (int i = 0; i < unwrappedMsgs.length; ++i) {
            int msgNr = msgs[i] == null ? -1 : msgs[i].getMessageNumber();
            log.debug("Unwrapping message (index {}) with number {}.", (Object)i, (Object)msgNr);
            unwrappedMsgs[i] = this.unwrap(msgs[i]);
            log.debug("Unwrapped message (index {}) with number {}.", (Object)i, (Object)msgNr);
        }
        return unwrappedMsgs;
    }

    public Message unwrap(Message msg) throws MessagingException {
        return msg;
    }
}

