/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.decrypt;

import jakarta.mail.Session;
import net.savignano.cryptography.key.pgp.PgpDecryptionKey;
import net.savignano.cryptography.key.smime.SmimeDecryptionKey;
import net.savignano.cryptography.mail.IKeyProvider;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpDecryptionKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimeDecryptionKeyManager;
import net.savignano.snotify.jira.common.JiraConstants;
import net.savignano.snotify.jira.mailer.decrypt.AComposedMailDecryptor;
import net.savignano.thirdparty.org.bouncycastle.cms.KeyTransRecipientId;

public class ComposedMailDecryptor
extends AComposedMailDecryptor {
    private final ISnotifyAppProperties appProps;

    public ComposedMailDecryptor(Session session, ISnotifyAppProperties appProps) {
        super(session, JiraConstants.PRODUCT_INFORMATION);
        this.appProps = appProps;
        this.setCheckPgpInline(appProps.getBoolean(EProperty.TWEAK_PGP_INLINE_SUPPORT));
        this.setCheckPgpBinaryAttachment(appProps.getString(EProperty.TWEAK_PGP_BINARY_REGEX));
    }

    public ISnotifyAppProperties getAppProps() {
        return this.appProps;
    }

    @Override
    protected IKeyProvider<Long, PgpDecryptionKey> createPgpKeyProvider() {
        PgpDecryptionKeyManager manager = new PgpDecryptionKeyManager(this.getAppProps());
        return forId -> (PgpDecryptionKey)manager.getKey(forId);
    }

    @Override
    protected IKeyProvider<KeyTransRecipientId, SmimeDecryptionKey> createSmimeKeyProvider() {
        SmimeDecryptionKeyManager manager = new SmimeDecryptionKeyManager(this.getAppProps());
        return forId -> (SmimeDecryptionKey)manager.getKey(forId);
    }

    @Override
    public void setCheckPgpInline(boolean checkPgpInline) {
        super.setCheckPgpInline(checkPgpInline);
    }

    @Override
    public void setCheckPgpBinaryAttachment(String checkPgpBinaryAttachment) {
        super.setCheckPgpBinaryAttachment(checkPgpBinaryAttachment);
    }
}

