/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.imap;

import jakarta.mail.FetchProfile;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.search.SearchTerm;
import java.util.Arrays;
import net.savignano.cryptography.LazyLog;
import net.savignano.snotify.jira.mailer.imap.ImapMessageTransformer;
import net.savignano.snotify.jira.mailer.imap.SnotifyImapMessage;
import org.eclipse.angus.mail.imap.AppendUID;
import org.eclipse.angus.mail.imap.IMAPFolder;
import org.eclipse.angus.mail.imap.IMAPMessage;
import org.eclipse.angus.mail.imap.IMAPStore;
import org.eclipse.angus.mail.imap.SortTerm;
import org.eclipse.angus.mail.imap.protocol.ListInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASnotifyImapFolder
extends IMAPFolder {
    private static final Logger log = LoggerFactory.getLogger(ASnotifyImapFolder.class);
    private final ImapMessageTransformer transformer;

    public ASnotifyImapFolder(ListInfo li, IMAPStore store) {
        super(li, store);
        log.trace("S/Notify IMAP folder implementation: {}", (Object)((Object)((Object)this)).getClass().getName());
        this.transformer = this.createMessageTransformer();
        if (this.transformer == null) {
            throw new IllegalStateException("Transformer must not be null.");
        }
    }

    public ASnotifyImapFolder(String fullName, char separator, IMAPStore store, Boolean isNamespace) {
        super(fullName, separator, store, isNamespace);
        log.trace("S/Notify IMAP folder implementation: {}", (Object)((Object)((Object)this)).getClass().getName());
        this.transformer = this.createMessageTransformer();
        if (this.transformer == null) {
            throw new IllegalStateException("Transformer must not be null.");
        }
    }

    public synchronized Message getMessageByUID(long uid) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to retrieve messages: getMessageByUID({})", (Object)uid);
        Message orgMsg = super.getMessageByUID(uid);
        return this.transformer.transformMessage(orgMsg);
    }

    public synchronized Message[] getMessagesByUID(long start, long end) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to retrieve messages: getMessageByUID({}, {})", (Object)start, (Object)end);
        Message[] orgMsgs = super.getMessagesByUID(start, end);
        return this.transformer.transformMessages(orgMsgs);
    }

    public synchronized Message[] getMessagesByUID(long[] uids) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to retrieve messages: getMessagesByUID({})", (Object)new LazyLog(() -> Arrays.toString(uids)));
        Message[] orgMsgs = super.getMessagesByUID(uids);
        return this.transformer.transformMessages(orgMsgs);
    }

    public synchronized Message[] getMessagesByUIDChangedSince(long start, long end, long modseq) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to retrieve messages: getMessagesByUIDChangedSince({}, {}, {})", new Object[]{start, end, modseq});
        Message[] orgMsgs = super.getMessagesByUIDChangedSince(start, end, modseq);
        return this.transformer.transformMessages(orgMsgs);
    }

    public synchronized Message getMessage(int msgnum) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to retrieve messages: getMessage({})", (Object)msgnum);
        Message orgMsg = super.getMessage(msgnum);
        return this.transformer.transformMessage(orgMsg);
    }

    public synchronized Message[] getMessages() throws MessagingException {
        log.trace("S/Notify IMAP folder method called to retrieve messages: getMessages()");
        Message[] orgMsgs = super.getMessages();
        return this.transformer.transformMessages(orgMsgs);
    }

    public synchronized Message[] getSortedMessages(SortTerm[] term, SearchTerm sterm) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to retrieve messages: getSortedMessages({}, {})", (Object)new LazyLog(() -> Arrays.toString(term)), (Object)sterm);
        Message[] orgMsgs = super.getSortedMessages(term, sterm);
        return this.transformer.transformMessages(orgMsgs);
    }

    public synchronized Message[] search(SearchTerm term) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to retrieve messages: search({})", (Object)term);
        Message[] orgMsgs = super.search(term);
        return this.transformer.transformMessages(orgMsgs);
    }

    public synchronized void appendMessages(Message[] msgs) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to change messages: appendMessages({})", (Object)new LazyLog(() -> Arrays.toString(msgs)));
        Message[] imapMsgs = this.transformer.unwrap(msgs);
        super.appendMessages(imapMsgs);
    }

    public synchronized AppendUID[] appendUIDMessages(Message[] msgs) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to change messages: appendUIDMessages({})", (Object)new LazyLog(() -> Arrays.toString(msgs)));
        Message[] imapMsgs = this.transformer.unwrap(msgs);
        return super.appendUIDMessages(imapMsgs);
    }

    public synchronized void copyMessages(Message[] msgs, Folder folder) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to change messages: copyMessages({}, {})", (Object)new LazyLog(() -> Arrays.toString(msgs)), (Object)folder);
        Message[] imapMsgs = this.transformer.unwrap(msgs);
        super.copyMessages(imapMsgs, folder);
    }

    public synchronized AppendUID[] copyUIDMessages(Message[] msgs, Folder folder) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to change messages: copyUIDMessages({}, {})", (Object)new LazyLog(() -> Arrays.toString(msgs)), (Object)folder);
        Message[] imapMsgs = this.transformer.unwrap(msgs);
        return super.copyUIDMessages(imapMsgs, folder);
    }

    public synchronized Message[] expunge(Message[] msgs) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to change messages: expunge({})", (Object)new LazyLog(() -> Arrays.toString(msgs)));
        Message[] imapMsgs = this.transformer.unwrap(msgs);
        return super.expunge(imapMsgs);
    }

    public synchronized long getUID(Message message) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to change messages: getUID({})", (Object)message);
        Message imapMsg = this.transformer.unwrap(message);
        return super.getUID(imapMsg);
    }

    public synchronized void moveMessages(Message[] msgs, Folder folder) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to change messages: moveMessages({}, {})", (Object)new LazyLog(() -> Arrays.toString(msgs)), (Object)folder);
        Message[] imapMsgs = this.transformer.unwrap(msgs);
        super.moveMessages(imapMsgs, folder);
    }

    public synchronized AppendUID[] moveUIDMessages(Message[] msgs, Folder folder) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to change messages: moveUIDMessages({}, {})", (Object)new LazyLog(() -> Arrays.toString(msgs)), (Object)folder);
        Message[] imapMsgs = this.transformer.unwrap(msgs);
        return super.moveUIDMessages(imapMsgs, folder);
    }

    public synchronized void setFlags(Message[] msgs, Flags flag, boolean value) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to change messages: setFlags({}, {}, {})", new Object[]{new LazyLog(() -> Arrays.toString(msgs)), flag, value});
        Message[] imapMsgs = this.transformer.unwrap(msgs);
        super.setFlags(imapMsgs, flag, value);
    }

    public synchronized Message[] search(SearchTerm term, Message[] msgs) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to retrieve messages: search({}, {})", (Object)term, (Object)new LazyLog(() -> Arrays.toString(msgs)));
        Message[] imapMsgs = this.transformer.unwrap(msgs);
        Message[] orgMsgs = super.search(term, imapMsgs);
        return this.transformer.transformMessages(orgMsgs);
    }

    public synchronized void fetch(Message[] msgs, FetchProfile fp) throws MessagingException {
        log.trace("S/Notify IMAP folder method called to change messages: fetch({}, {})", (Object)new LazyLog(() -> Arrays.toString(msgs)), (Object)fp);
        if (msgs == null || msgs.length == 0) {
            return;
        }
        if (!msgs.getClass().isAssignableFrom(SnotifyImapMessage[].class)) {
            log.warn("Cannot transform messages as given array is not compatible with S/Notify. Arrays class: {}", msgs.getClass());
            super.fetch(msgs, fp);
            return;
        }
        Message[] transformedMsgs = this.transformer.transformMessages(msgs);
        System.arraycopy(transformedMsgs, 0, msgs, 0, transformedMsgs.length);
    }

    protected abstract ImapMessageTransformer createMessageTransformer();

    protected IMAPMessage getMessageBySeqNumber(int seqnum) {
        log.trace("S/Notify IMAP folder method called to retrieve messages: getMessageBySeqNumber({})", (Object)seqnum);
        return super.getMessageBySeqNumber(seqnum);
    }

    protected IMAPMessage[] getMessagesBySeqNumbers(int[] seqnums) {
        log.trace("S/Notify IMAP folder method called to retrieve messages: getMessagesBySeqNumbers({})", (Object)new LazyLog(() -> Arrays.toString(seqnums)));
        return super.getMessagesBySeqNumbers(seqnums);
    }

    protected IMAPMessage newIMAPMessage(int msgnum) {
        log.trace("S/Notify IMAP folder method called to retrieve messages: newIMAPMessage({})", (Object)msgnum);
        return super.newIMAPMessage(msgnum);
    }
}

