/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.imap;

import jakarta.mail.Session;
import jakarta.mail.URLName;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.jira.mailer.imap.SnotifyImapFolder;
import org.eclipse.angus.mail.imap.IMAPStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyImapStore
extends IMAPStore {
    private static final Logger log = LoggerFactory.getLogger(SnotifyImapStore.class);

    private static final Session addFolderProperty(Session session) {
        if (SecurityUtil.checkSelfIntegrity()) {
            session.getProperties().put("mail.imap.folder.class", SnotifyImapFolder.class.getName());
        } else {
            log.error("Signature of S/Notify is not correct. To protect underlying system, S/Notify will be disabled, as it has been tampered with.");
        }
        return session;
    }

    public SnotifyImapStore(Session session, URLName url) {
        super(SnotifyImapStore.addFolderProperty(session), url);
        log.debug("Using S/Notify IMAP store implementation to receive emails.");
        log.trace("Session properties used: {}", (Object)session.getProperties());
        SecurityUtil.getProvider();
    }
}

