/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.jira.mailer.pop3;

import jakarta.mail.Folder;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.URLName;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.jira.mailer.pop3.SnotifyPop3Folder;
import org.eclipse.angus.mail.pop3.POP3SSLStore;
import org.eclipse.angus.mail.pop3.POP3Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyPop3sStore
extends POP3SSLStore {
    private static final Logger log = LoggerFactory.getLogger(SnotifyPop3sStore.class);

    public SnotifyPop3sStore(Session session, URLName url) {
        super(session, url);
        log.debug("Using S/Notify POP3 SSL Store implementation to receive emails.");
        log.trace("Session properties used: {}", (Object)session.getProperties());
        SecurityUtil.getProvider();
    }

    public Folder getFolder(String name) throws MessagingException {
        if (!SecurityUtil.checkSelfIntegrity()) {
            log.error("Signature of S/Notify is not correct. To protect underlying system, S/Notify will be disabled, as it has been tampered with.");
            return super.getFolder(name);
        }
        this.checkConnected();
        return new SnotifyPop3Folder((POP3Store)this, name);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        if (!SecurityUtil.checkSelfIntegrity()) {
            log.error("Signature of S/Notify is not correct. To protect underlying system, S/Notify will be disabled, as it has been tampered with.");
            return super.getFolder(url);
        }
        this.checkConnected();
        return new SnotifyPop3Folder((POP3Store)this, url.getFile());
    }

    private void checkConnected() throws MessagingException {
        if (!this.isConnected()) {
            throw new MessagingException("Not connected.");
        }
    }
}

