/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGKey;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGObject;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.MPInteger;

public class ElGamalPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger p;
    MPInteger g;
    MPInteger y;

    public ElGamalPublicBCPGKey(BCPGInputStream in) throws IOException {
        this.p = new MPInteger(in);
        this.g = new MPInteger(in);
        this.y = new MPInteger(in);
    }

    public ElGamalPublicBCPGKey(BigInteger p, BigInteger g, BigInteger y) {
        this.p = new MPInteger(p);
        this.g = new MPInteger(g);
        this.y = new MPInteger(y);
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    public BigInteger getP() {
        return this.p.getValue();
    }

    public BigInteger getG() {
        return this.g.getValue();
    }

    public BigInteger getY() {
        return this.y.getValue();
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writeObject(this.p);
        out.writeObject(this.g);
        out.writeObject(this.y);
    }
}

