/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Set;
import net.savignano.thirdparty.org.bouncycastle.asn1.BEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.ContentInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.EncryptedData;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSEncryptedGenerator;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSTypedData;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSUtils;
import net.savignano.thirdparty.org.bouncycastle.operator.OutputEncryptor;

public class CMSEncryptedDataGenerator
extends CMSEncryptedGenerator {
    private CMSEncryptedData doGenerate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            OutputStream cOut = contentEncryptor.getOutputStream(bOut);
            content.write(cOut);
            cOut.close();
        }
        catch (IOException e) {
            throw new CMSException("");
        }
        byte[] encryptedContent = bOut.toByteArray();
        AlgorithmIdentifier encAlgId = contentEncryptor.getAlgorithmIdentifier();
        BEROctetString encContent = new BEROctetString(encryptedContent);
        EncryptedContentInfo eci = CMSUtils.getEncryptedContentInfo(content.getContentType(), encAlgId, encryptedContent);
        ASN1Set unprotectedAttrSet = CMSUtils.getAttrBERSet(this.unprotectedAttributeGenerator);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.encryptedData, new EncryptedData(eci, unprotectedAttrSet));
        return new CMSEncryptedData(contentInfo);
    }

    public CMSEncryptedData generate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        return this.doGenerate(content, contentEncryptor);
    }
}

