/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.agreement;

import net.savignano.thirdparty.org.bouncycastle.crypto.CipherParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.crypto.RawAgreement;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.Utils;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.X448PublicKeyParameters;

public final class X448Agreement
implements RawAgreement {
    private X448PrivateKeyParameters privateKey;

    @Override
    public void init(CipherParameters parameters) {
        this.privateKey = (X448PrivateKeyParameters)parameters;
        CryptoServicesRegistrar.checkConstraints(Utils.getDefaultProperties("X448", this.privateKey));
    }

    @Override
    public int getAgreementSize() {
        return 56;
    }

    @Override
    public void calculateAgreement(CipherParameters publicKey, byte[] buf, int off) {
        this.privateKey.generateSecret((X448PublicKeyParameters)publicKey, buf, off);
    }
}

